import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from '@/store'

// vue-meta
import VueMeta from 'vue-meta'
Vue.use(VueMeta)

import { Icon } from 'vant'
Vue.use(Icon)
// vant
import { Notify } from 'vant'
Vue.use(Notify)

import { Dialog } from 'vant'
Vue.use(Dialog)

import { Toast } from 'vant'
Vue.use(Toast)

import { Popup } from 'vant'
Vue.use(Popup)

import { Progress } from 'vant'
Vue.use(Progress)

import { Tab, Tabs } from 'vant'
Vue.use(Tab)
Vue.use(Tabs)

import { Form } from 'vant'
Vue.use(Form)

import { Field } from 'vant'
Vue.use(Field)

import { Button } from 'vant'
Vue.use(Button)

import { Checkbox, CheckboxGroup } from 'vant'
Vue.use(Checkbox)
Vue.use(CheckboxGroup)

import { RadioGroup, Radio } from 'vant'
Vue.use(Radio)
Vue.use(RadioGroup)

import { DatetimePicker } from 'vant'
Vue.use(DatetimePicker)

import { Picker } from 'vant'
Vue.use(Picker)

import { Uploader } from 'vant'
Vue.use(Uploader)

import { List } from 'vant'
Vue.use(List)

import { IndexBar, IndexAnchor } from 'vant'
Vue.use(IndexBar)
Vue.use(IndexAnchor)

import { Area } from 'vant'
Vue.use(Area)

import { ActionSheet } from 'vant'
Vue.use(ActionSheet)

// 公共css
import '@/assets/css/base.css'

Vue.config.productionTip = false

import avatar from '@/assets/img/avatar.png'
Vue.filter('avatar', function(value) {
  return value && value !== 'null' ? value : avatar
})

/* 导航守卫 */
router.beforeEach((to, from, next) => {
  if (to.meta.requiredLogin) {
    store.dispatch('checkLogin').then(isLogin => {
      isLogin
        ? next()
        : next({
            path: '/login',
            query: { redirect_uri: encodeURIComponent(window.location.href) }
          })
    })
    return
  }
  next()
})

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
