const fs = require('fs')
const path = require('path')

module.exports = {
  devServer: {
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './cert/dev.ezijing.com.key')),
      cert: fs.readFileSync(path.join(__dirname, './cert/dev.ezijing.com.pem'))
    },
    proxy: {
      '/api': {
        target: 'https://alumni2.ezijing.com'
      }
    }
  },
  configureWebpack : {
    performance: {
      hints:'warning',
      //入口起点的最大体积 整数类型（以字节为单位）
      maxEntrypointSize: 50000000,
      //生成文件的最大体积 整数类型（以字节为单位 300k）
      maxAssetSize: 30000000,
      //只给出 js 文件的性能提示
      assetFilter: function(assetFilename) {
          return assetFilename.endsWith('.js');
      }
    }
  }
}
