import httpRequest from '@/utils/axios'

// 上传文件
export function upload(data) {
  return httpRequest({
    url: '/api/alumni/v1/activities/tool/upload-file',
    method: 'post',
    headers: {
      'Content-Type': 'multipart/form-data'
    },
    data
  })
}

// 获取视频上传地址和凭证
export function uploadVideoAuth(data) {
  return httpRequest({
    url: '/api/alumni/v1/graduation/auth',
    method: 'post',
    data
  })
}

// 获取热门推荐列表
export function getHotList(params) {
  return httpRequest({
    url: '/api/alumni/v1/activities/hotest',
    method: 'get',
    params
  })
}

// 获取我参与的列表
export function getJoinList(params) {
  return httpRequest({
    url: '/api/alumni/v1/activities/my/participanted',
    method: 'get',
    params
  })
}

// 获取我发起的列表
export function getPublishList(params) {
  return httpRequest({
    url: '/api/alumni/v1/activities/my/initiated',
    method: 'get',
    params
  })
}

// 获取活动详情
export function getActivity(id) {
  return httpRequest.get(`/api/alumni/v1/activities2/detail/${id}`)
}

// 报名活动
export function joinActivity(id) {
  return httpRequest.post(`/api/alumni/v1/activities2/join/${id}`)
}

// 取消报名活动
export function cancelJoinActivity(id) {
  return httpRequest.post(`/api/alumni/v1/activities2/cancel/${id}`)
}

// 创建活动
export function createActivity(data) {
  return httpRequest.post('/api/alumni/v1/activities2/add', data)
}

// 修改活动
export function updateActivity(id, data) {
  return httpRequest.post(`/api/alumni/v1/activities2/edit/${id}`, data)
}

// 删除活动
export function deleteActivity(id) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}`,
    method: 'delete'
  })
}

// 获取活动评论列表
export function getCommentList(id) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/replies`,
    method: 'get'
  })
}

// 添加评论
export function addComment(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/reply`,
    method: 'post',
    data
  })
}

// 上传资料
export function addSubmitStudent(data) {
  return httpRequest({
    url: `/api/alumni/v1/graduation/add`,
    method: 'post',
    data
  })
}

// 添加回复
export function addCommentReplay(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/comment`,
    method: 'post',
    data
  })
}

// 点赞
export function addCommentLike(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/like`,
    method: 'post',
    data
  })
}

// 取消点赞
export function removeCommentLike(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/unlike`,
    method: 'post',
    data
  })
}

// 删除评论
export function deleteComment(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/reply/delete`,
    method: 'delete',
    data
  })
}

// 删除评论的回复
export function deleteCommentReply(id, data) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/comment/delete`,
    method: 'delete',
    data
  })
}

// 获取评论详情
export function getComment(id, params) {
  return httpRequest({
    url: `/api/alumni/v1/activities/${id}/reply/comments`,
    method: 'get',
    params
  })
}

// 获取活动列表
export function getActivityList(params) {
  return httpRequest.get('/api/alumni/v1/activities2/list', { params })
}

// 获取活动详情
export function getActivityDetail(id) {
  return httpRequest.get(`/api/alumni/v1/activities/${id}`)
}

// 创建活动
export function addActivity(data) {
  return httpRequest.post('/api/alumni/v1/activities2/add', data)
}

// 更新活动
export function updateActivity2(id, data) {
  return httpRequest.post(`/api/alumni/v1/activities2/edit/${id}`, data)
}

// 审核活动成员
export function updateActivityMemberStatus(id, data) {
  return httpRequest.post(`/api/alumni/v1/activities2/join/check/${id}`, data)
}

// 获取组织列表
export function getGroupList(params) {
  return httpRequest.get('/api/alumni/v1/organization/list', { params })
}

// 获取组织详情
export function getGroup(id) {
  return httpRequest.get(`/api/alumni/v1/organization/detail/${id}`)
}

// 创建组织
export function addGroup(data) {
  return httpRequest.post('/api/alumni/v1/organization/add', data)
}

// 更新组织
export function updateGroup(id, data) {
  return httpRequest.post(`/api/alumni/v1/organization/edit/${id}`, data)
}

// 加入组织
export function joinGroup(id, data) {
  return httpRequest.post(`/api/alumni/v1/organization/join/${id}`, data)
}

// 退出组织
export function leaveGroup(id) {
  return httpRequest.post(`/api/alumni/v1/organization/cancel/${id}`)
}

// 审核组织成员
export function updateGruopMemberStatus(id, data) {
  return httpRequest.post(`/api/alumni/v1/organization/join/check/${id}`, data)
}

// 获取组织内的活动
export function getActivitesByGroup(groupId, params) {
  return httpRequest.get(`/api/alumni/v1/activities2/inorg/${groupId}`, {
    params
  })
}

// 获取成员列表
export function getMemberList(params) {
  return httpRequest.get('/api/alumni/v1/student/list', { params })
}

// 获取我的信息
export function getMy() {
  return httpRequest.get('/api/alumni/v1/student/total')
}

// 获取我参与的组织
export function getJoinedGroupes(params) {
  return httpRequest.get('/api/alumni/v1/organization/joined', { params })
}

// 获取我创建的组织
export function getMyGroupes(params) {
  return httpRequest.get('/api/alumni/v1/organization/my', { params })
}

// 获取我参与的活动
export function getJoinedActivities(params) {
  return httpRequest.get('/api/alumni/v1/activities2/joined', { params })
}

// 获取我的审批
export function getMyApproves(params) {
  return httpRequest.get('/api/alumni/v1/activities2/check/list', { params })
}

// 审核活动
export function updateActivityStatus(id, data) {
  return httpRequest.post(`/api/alumni/v1/activities2/check/${id}`, data)
}

// 获取未读消息
export function getUnreadMessage() {
  return httpRequest.get('/api/alumni/v1/student/unread')
}

// 获取消息列表
export function getMessageList(params) {
  return httpRequest.get('/api/alumni/v1/student/messages', { params })
}

// 获取消息详情
export function getMessage(id) {
  return httpRequest.get(`/api/alumni/v1/student/messages/detail/${id}`)
}

// 获取消息详情
export function readMessage(id) {
  return httpRequest.post(`/api/alumni/v1/student/messages/read/${id}`)
}

// 获取热门推荐
export function getPopular() {
  return httpRequest.get('/api/alumni/v1/organization/recommend')
}
