import httpRequest from '@/utils/axios'

// 登录
export function login(data) {
  return httpRequest({
    url: '/api/passport/rest/login',
    method: 'post',
    data
  })
}
// 绑定微信
export function bindWechat(data) {
  return httpRequest({
    url: '/api/passport/rest/wechat/bind-unionid',
    method: 'post',
    data
  })
}
// 重置密码
export function resetPassword(data) {
  return httpRequest({
    url: '/api/usercenter/user/update-pwd',
    method: 'post',
    data
  })
}
// 发送重置验证码
export function sendResetPasswordCode(data) {
  return httpRequest({
    url: '/api/usercenter/user/send-code',
    method: 'post',
    data
  })
}
// 登出
export function logout() {
  return httpRequest.post('https://learn-pbcsf.ezijing.com/api/clear/cookie')
}

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}
