import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from '@/store'

import Vant from 'vant'
import 'vant/lib/index.css'
Vue.use(Vant)

// vue-meta
import VueMeta from 'vue-meta'
Vue.use(VueMeta)

// 公共css
import '@/assets/css/base.css'

Vue.config.productionTip = false

import avatar from '@/assets/img/avatar.png'
Vue.filter('avatar', function(value) {
  return value && value !== 'null' ? value : avatar
})

/* 导航守卫 */
router.beforeEach((to, from, next) => {
  if (to.meta.requiredLogin) {
    store.dispatch('checkLogin').then(isLogin => {
      isLogin
        ? next()
        : next({
            path: '/login',
            query: { redirect_uri: encodeURIComponent(window.location.href) }
          })
    })
    return
  }
  next()
})

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
