import Vue from 'vue'
import VueRouter from 'vue-router'

Vue.use(VueRouter)

const routes = [
  { path: '*', redirect: '/' },
  {
    name: 'login',
    path: '/login',
    component: () => import('@/views/login/Login.vue')
  },
  // 首页
  {
    path: '/',
    name: 'home',
    component: () => import('@/views/home/Index.vue')
  },
  // 搜索
  {
    path: '/search',
    name: 'search',
    component: () => import('@/views/search/Index.vue')
  },
  // 创建
  {
    path: '/create',
    name: 'create',
    component: () => import('@/views/create/Index.vue')
  },
  // 创建组织
  {
    path: '/create/group',
    name: 'createGroup',
    component: () => import('@/views/create/Group.vue')
  },
  // 创建活动
  {
    path: '/create/activity',
    name: 'createActivity',
    component: () => import('@/views/create/Activity.vue')
  },
  // 我的
  {
    path: '/my',
    name: 'my',
    component: () => import('@/views/my/Index.vue')
  },
  // 我的消息
  {
    path: '/message',
    name: 'message',
    component: () => import('@/views/message/Index.vue')
  },
  // 消息列表
  {
    path: '/message/:type',
    name: 'messageList',
    component: () => import('@/views/message/List.vue')
  },
  // 消息详情
  {
    path: '/message/:type/:id',
    name: 'messageItem',
    component: () => import('@/views/message/Item.vue')
  },
  // 设置
  {
    path: '/settings',
    name: 'settings',
    component: () => import('@/views/settings/Index.vue')
  },
  // 我的组织
  {
    path: '/my/group',
    name: 'myGroup',
    component: () => import('@/views/my/MyGroup.vue')
  },
  // 我的活动
  {
    path: '/my/activity',
    name: 'myActivity',
    component: () => import('@/views/my/MyActivity.vue')
  },
  // 我的审批
  {
    path: '/my/approve',
    name: 'myApprove',
    component: () => import('@/views/my/MyApprove.vue')
  },
  // 活动列表
  {
    path: '/activity',
    name: 'activity',
    component: () => import('@/views/activity/Index.vue')
  },
  // 活动详情
  {
    path: '/activity/:id',
    name: 'activityItem',
    component: () => import('@/views/activity/Item.vue')
  },
  // 活动评论
  {
    path: '/activity/:id/comment/:commentId',
    name: 'activityComment',
    component: () => import('@/views/activity/Comment.vue')
  },
  // 编辑活动
  {
    path: '/activity/:id/update',
    name: 'activityUpdate',
    component: () => import('@/views/activity/Update.vue')
  },
  // 活动成员列表
  {
    path: '/activity/:id/member',
    name: 'activityMember',
    component: () => import('@/views/activity/Member.vue')
  },
  // 组织列表
  {
    path: '/group',
    name: 'group',
    component: () => import('@/views/group/Index.vue')
  },
  // 组织详情
  {
    path: '/group/:id',
    name: 'groupItem',
    component: () => import('@/views/group/Item.vue')
  },
  // 编辑组织
  {
    path: '/group/:id/update',
    name: 'groupUpdate',
    component: () => import('@/views/group/Update.vue')
  },
  // 组织成员列表
  {
    path: '/group/:id/member',
    name: 'groupMember',
    component: () => import('@/views/group/Member.vue')
  },
  // 组织活动列表
  {
    path: '/group/:id/activity',
    name: 'groupActivity',
    component: () => import('@/views/group/Activity.vue')
  },
  //学员提交
  {
    path: '/submit',
    name: 'submitStudent',
    component: () => import('@/views/submitStudent/submitStudent.vue'),
    meta: { requiredLogin: true }
  }
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes,
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) {
      return savedPosition
    } else {
      return { x: 0, y: 0 }
    }
  }
})

export default router
