import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from '@/store'
import modules from './modules'
import beforeEnter from '@/utils/beforeEnter'

// Element-UI
import ElementUI from 'element-ui'
import '@/assets/theme/index.css'

// vant
import Vant from 'vant'
import 'vant/lib/index.css'
// 公共css
import '@/assets/css/base.css'

Vue.use(ElementUI)
Vue.use(Vant)

// 注册模块
modules({ router, store })

router.beforeEach(beforeEnter)

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
