import { getUser, logout } from '@/api/base'
const user = {
  state: {
    user: {},
    isLogin: false
  },

  mutations: {
    setUser(state, user) {
      state.user = user
    },
    setIsLogin(state, isLogin) {
      state.isLogin = isLogin
    }
  },

  actions: {
    // 获取用户信息
    getUser({ commit }) {
      getUser().then(response => {
        commit('setUser', response.data)
      })
    },
    // 退出登录
    logout({ commit }) {
      return logout().then(response => {
        commit('setUser', {})
        commit('setIsLogin', false)
        return response
      })
    },
    // 检测登录状态
    async checkLogin({ commit }) {
      const isLogin = await getUser()
        .then(response => {
          if (response.code === 0) {
            commit('setUser', response.data)
            return true
          } else {
            return false
          }
        })
        .catch(() => {
          commit('setUser', {})
          return false
        })
      commit('setIsLogin', isLogin)
      return isLogin
    }
  }
}

export default user
