export type Presets = {
  label: string
  value: string
}[]

export type MenuType = {
  menus: string[]
  presets: FnType<Presets, FnType<string, string>>
  operators: string[]
  greekLetters: string[]
  inequation: string[]
  AdvancedMath: string[]
  LinearAlgebra: string[]
  arrows: string[]
  trigonometric: string[]
  physical: string[]
  chemistry: string[]
}

/** 编辑器按钮配置 */
export const menusConfig: MenuType = {
  menus: [
    'presets',
    'operators',
    'greekLetters',
    'inequation',
    'AdvancedMath',
    'LinearAlgebra',
    'arrows',
    'Trigonometric',
    'physical',
    'chemistry'
  ],
  presets(t: FnType<string, string>): Presets {
    return [
      // 勾股定理
      {
        label: t('fe.pt'),
        value: 'a^2+b^2=c^2',
      },
      // 双曲线
      {
        label: t('fe.h'),
        value: '\\frac{x^2}{a^2}-\\frac{y^2}{b^2}=1',
      },
      // 三角函数关系
      {
        label: t('fe.tfr'),
        value: '\\sin^2\\theta +\\cos^2\\theta = 1',
      },
      // 导数
      {
        label: t('fe.d'),
        value: "\\left( e^x \\right) ' = e^x",
      },
      // 牛莱公式
      {
        label: t('fe.nl'),
        value: '\\int_a^b f(x) dx = F(b) - F(a)',
      },
    ]
  },
  operators: [
    '+',
    '-',
    '\\pm',
    '\\mp',
    '\\times',
    '\\div',
    '\\ast',
    '\\cdot',
    '\\cap',
    '\\cup',
    '\\aleph',
    '\\Re',
    '\\top',
    '\\bot',
    '\\infty',
    '\\partial',
    '\\forall',
    '\\exists',
    '\\neg',
    '\\because',
    '\\therefore',
    '\\varnothing',
    '\\frac{b}{a}',
    '\\circ',
    '\\bullet',
    '\\prime',
    '\\triangle',
    '\\angle',
    '\\surd',
    '\\barwedge',
    '\\veebar',
    '\\odot',
    '\\oplus',
    '\\otimes',
    '\\oslash',
    '\\circledcirc',
    '\\boxdot',
    '\\bigtriangledown',
    '\\dagger',
    '\\diamond',
    '\\star',
    '\\triangleleft',
    '\\triangleright',
  ],
  greekLetters: [
    '\\alpha',
    '\\beta',
    '\\gamma',
    '\\delta',
    '\\epsilon',
    '\\zeta',
    '\\eta',
    '\\theta',
    '\\iota',
    '\\kappa',
    '\\lambda',
    '\\mu',
    '\\nu',
    '\\xi',
    '\\omicron',
    '\\pi',
    '\\rho',
    '\\sigma',
    '\\tau',
    '\\upsilon',
    '\\phi',
    '\\chi',
    '\\psi',
    '\\omega',
    '\\varepsilon',
    '\\vartheta',
    '\\varpi',
    '\\varrho',
    '\\varsigma',
    '\\varphi',
    '\\Gamma',
    '\\Delta',
    '\\Theta',
    '\\Lambda',
    '\\Xi',
    '\\Pi',
    '\\Sigma',
    '\\Upsilon',
    '\\Phi',
    '\\Psi',
    '\\Omega',
  ],
  inequation: [
    '=',
    '\\leq',
    '\\geq',
    '\\prec',
    '\\succ',
    '\\preceq',
    '\\succeq',
    '\\ll',
    '\\gg',
    '\\equiv',
    '\\sim',
    '\\simeq',
    '\\asymp',
    '\\approx',
    '\\ne',
    '\\subset',
    '\\supset',
    '\\subseteq',
    '\\supseteq',
    '\\nsubseteq',
    '\\nsupseteq',
    '\\in',
    '\\ni',
    '\\notin',
  ],
  AdvancedMath: [
    'x_{a}',
    'x^{b}',
    'x_{a}^{b}',
    '\\sqrt{x}',
    '\\sqrt[n]{x}',
    '\\bigcap_{a}^{b}',
    '\\bigcup_{a}^{b}',
    '\\prod_{a}^{b}',
    '\\coprod_{a}^{b}',
    '\\int_{a}^{b}',
    '\\oint_{a}^{b}',
    '\\sum_{a}^{b}{x}',
    '\\lim_{a  \\rightarrow b}{x}',
    '\\frac{dy}{dx}|_{t=0}',
    '\\vec{a}',
    '\\bar{a}',
    '\\tilde{a}',
    '\\dot{a}',
    '\\ddot{a}',
    '\\hat{a}',
    '\\overleftarrow{ab}',
    '\\overline{ab}',
    '\\overrightarrow{ab}',
    '\\underline{ab}',
    '\\overbrace{ab}',
    '\\underbrace{ab}',
  ],
  LinearAlgebra: [
    'A^{*}',
    'A^{T}',
    'A^{-1}',
    '\\left( x  \\right)',
    '\\left[ x  \\right]',
    '\\left \\{ x  \\right \\}',
    '\\left| x  \\right|',
    '\\begin{pmatrix}a&b\\\\c&d\\\\ \\end{pmatrix}',
    '\\begin{bmatrix}a&b\\\\c&d\\\\ \\end{bmatrix}',
    '\\begin{Bmatrix}a&b\\\\c&d\\\\ \\end{Bmatrix}',
    '\\begin{vmatrix}a&b\\\\c&d\\\\ \\end{vmatrix}',
  ],
  arrows: [
    '\\leftarrow',
    '\\rightarrow',
    '\\leftrightarrow',
    '\\Leftarrow',
    '\\Rightarrow',
    '\\Leftrightarrow',
    '\\uparrow',
    '\\downarrow',
    '\\updownarrow',
    '\\Uparrow',
    '\\Downarrow',
    '\\Updownarrow',
  ],
  trigonometric: [
    '\\sin \\theta',
    '\\cos \\theta',
    '\\tan \\theta',
    '\\csc \\theta',
    '\\sec \\theta',
    '\\cot \\theta',
    '\\arcsin \\theta',
    '\\arccos \\theta',
  ],
  // 物理
  physical: [
    'E = n{{ \\Delta \\Phi } \\over {\\Delta {t} }}',
    '\\sum {{{ \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over F} }_i}} = \\frac{{d \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over v} }}{{dt}} = 0',
    '\\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over F}  = m \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}}  \\over a}  = m \\frac{{{d^2} \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over r} }}{{d{t^2}}}',
    '{{ \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over F} }_{12}} =  - {{ \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}}  \\over F} }_{21}}',
    '{E_p} = -\\frac{{GMm}}{r}',
    '\\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}}  \\over F}  = k \\frac{{Qq}}{{{r^2}}} \\hat{r}',
    '\\oint_L { \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over E} } \\cdot { \\rm{d}} \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}}  \\over l}  = 0',
    '\\mathop \\Phi \\nolimits_e = \\oint { \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over E} \\cdot {d \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over S}}  = {1 \\over {{\\varepsilon _0}}}\\sum {q} }',
    '\\mathop \\Phi \\nolimits_e = \\oint { \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over E} \\cdot {d \\mathord{ \\buildrel{ \\lower3pt \\hbox{$ \\scriptscriptstyle \\rightharpoonup$}} \\over S}}  = {1 \\over {{\\varepsilon _0}}}\\sum {q} }'
  ],
  // 化学
  chemistry : [
    '\\ce{SO4^2- + Ba^2+ -> BaSO4 v}',
    '\\ce{A v B (v) -> B ^ B (^)}',
    '\\ce{Hg^2+ ->[I-]  $\\underset{\\mathrm{red}}{\\ce{HgI2}}$  ->[I-]  $\\underset{\\mathrm{red}}{\\ce{[Hg^{II}I4]^2-}}$}',
    '\\ce{Zn^2+  <=>[+ 2OH-][+ 2H+]  $\\underset{\\text{amphoteres Hydroxid}}{\\ce{Zn(OH)2 v}}$  <=>[+ 2OH-][+ 2H+]  $\\underset{\\text{Hydroxozikat}}{\\ce{[Zn(OH)4]^2-}}$}'
  ]
}
