import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class GalleryAuto {
  constructor() {
    this.title = '画廊'
    this.iconSvg = `<svg width="24px" height="19px" viewBox="0 0 24 19" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-677.000000, -1030.000000)">
            <g id="右侧章节目录" transform="translate(551.000000, 592.000000)">
                <rect id="边框" stroke="#CCCCCC" fill="#EEEEEE" opacity="0.302679084" x="0.5" y="50.5" width="259" height="666"></rect>
                <g id="媒体资源" transform="translate(11.000000, 400.000000)" fill="#666666" fill-rule="nonzero">
                    <g id="视频播放" transform="translate(115.000000, 38.000000)">
                        <path d="M9.64798915,14 C9.76728423,14 9.87844555,13.9618138 9.97605061,13.8949881 L14.6312698,10.7128083 C14.8481699,10.5982498 15,10.3341289 15,10.0286396 C15,9.7486078 14.8698599,9.50039777 14.677361,9.3699284 L10.1278807,6.25775656 C10.0112969,6.09864757 9.83777677,6 9.64798915,6 C9.29281518,6 9.00813376,6.34049324 9.00813376,6.75735879 L9.00813376,6.79872713 L9,6.80509149 L9.01084501,13.1630867 C9.00813376,13.1885442 9.00813376,13.2140016 9.00813376,13.2426412 C9.00813376,13.6626889 9.29552643,14 9.64798915,14 L9.64798915,14 Z" id="路径"></path>
                        <path d="M2.27373675e-13,11 C2.27373675e-13,11.3572656 0.190598914,11.6873926 0.5,11.8660254 C0.809401074,12.0446582 1.19059893,12.0446582 1.5,11.8660254 C1.80940109,11.6873926 2,11.3572656 2,11 C2,10.6427344 1.80940109,10.3126074 1.5,10.1339746 C1.19059893,9.9553418 0.809401074,9.9553418 0.5,10.1339746 C0.190598914,10.3126074 2.27373675e-13,10.6427344 2.27373675e-13,11 L2.27373675e-13,11 Z" id="路径"></path>
                        <path d="M23.9946417,6.45843399 C23.9973208,6.41523376 24,6.37203354 24,6.32883331 C24,5.38382834 23.2364367,4.61972431 22.2960482,4.61972431 C21.9825854,4.61972431 21.6878768,4.70612477 21.4333557,4.85462555 L21.4199598,4.84652551 L20.5760214,5.33792809 L20.5760214,3.5910189 C20.5733423,1.61730851 18.9711989,0 17.0100469,0 L3.56329538,0 C1.60482251,0 2.27373675e-13,1.6146085 2.27373675e-13,3.5910189 L2.27373675e-13,8.06764246 L0.00535833892,8.06764246 C0.00535833892,8.54554498 0.391158741,8.93434702 0.868050904,8.93434702 C1.34494307,8.93434702 1.73074347,8.54554498 1.73074347,8.06764246 L1.73610181,8.06764246 L1.73610181,3.45331818 C1.73610181,2.50291317 2.50770261,1.72530908 3.45077026,1.72530908 L17.1198928,1.72530908 C18.0629605,1.72530908 18.8345613,2.50291317 18.8345613,3.45331818 L18.8345613,15.573682 C18.8345613,16.524087 18.0629605,17.3016911 17.1198928,17.3016911 L3.45344943,17.3016911 C2.51038178,17.3016911 1.73878098,16.524087 1.73878098,15.573682 L1.73878098,14.9958789 C1.73878098,14.5179764 1.35298058,14.1291744 0.876088413,14.1291744 C0.399196249,14.1291744 0.0133958473,14.5179764 0.0133958473,14.9958789 L0.00267916946,14.9958789 L0.00267916946,15.4089811 C0.00267916946,17.3853915 1.60750167,19 3.56597455,19 L17.0127261,19 C18.9738781,19 20.5760214,17.3853915 20.5760214,15.4089811 L20.5760214,13.678272 L21.4628265,14.1939747 L21.4655057,14.1912747 C21.7119893,14.3289754 21.9959812,14.4072758 22.2960482,14.4072758 C23.2364367,14.4072758 24,13.6404718 24,12.6981668 C24,12.6549666 23.9973208,12.6117664 23.9946417,12.5685662 L23.9946417,6.45843399 Z M22.2906899,11.9961631 C22.2826524,12.2067642 22.1058272,12.3768651 21.8888145,12.3768651 C21.8164769,12.3768651 21.7468185,12.357965 21.6878768,12.3228649 L20.5760214,11.6829615 L20.5760214,7.31703851 L21.6718017,6.69063521 C21.7334226,6.650135 21.8084394,6.62853489 21.8888145,6.62853489 C22.1111855,6.62853489 22.2906899,6.80673582 22.2906899,7.02273696 L22.2906899,11.9961631 L22.2906899,11.9961631 Z" id="形状"></path>
                    </g>
                </g>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false;
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('GalleryMenuClick');
  }
}

export default {
  key: 'GalleryAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new GalleryAuto() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  GalleryAuto
}