import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class VideoAuto {
  constructor() {
    this.title = '视频'
    this.iconSvg = `<svg width="21px" height="21px" viewBox="0 0 21 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-623.000000, -1027.000000)">
            <g id="右侧章节目录" transform="translate(551.000000, 592.000000)">
                <rect id="边框" stroke="#CCCCCC" fill="#EEEEEE" opacity="0.302679084" x="0.5" y="50.5" width="259" height="666"></rect>
                <g id="媒体资源" transform="translate(11.000000, 400.000000)" fill="#666666" fill-rule="nonzero">
                    <g id="画廊上传" transform="translate(61.000000, 35.000000)">
                        <path d="M6.3,0 L6.3,4.19999998 L2.10000002,4.19999998 L2.10000002,18.9 L18.9,18.9 L18.9,2.09999999 L19.9584,2.09999999 C20.5338,2.09999999 21,2.56725 21,3.14264999 L21,19.95735 C20.9960018,20.5311167 20.5321624,20.9954237 19.9584,21 L1.04160002,21 C0.466170409,20.9994205 2.27373675e-13,20.5327799 2.27373675e-13,19.95735 L2.27373675e-13,3.14264999 C0.00399821879,2.56888331 0.467837653,2.1045763 1.04160002,2.09999999 L4.20000001,2.09999999 L4.20000001,0 L6.3,0 Z M10.5,7.34999998 L14.7,11.55 L11.55,11.55 L11.55,15.75 L9.45,15.75 L9.45,11.55 L6.3,11.55 L10.5,7.34999998 Z M16.8,0 L16.8,4.19999998 L8.40000002,4.19999998 L8.40000002,2.09999999 L14.7,2.09999999 L14.7,0 L16.8,0 Z" id="形状"></path>
                    </g>
                </g>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('VideoMenuClick');
  }
}

export default {
  key: 'VideoAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new VideoAuto() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  VideoAuto
}