import BaseModalMenu from './common/BaseModalMenu'
import AISearchModal from './common/AISearchModal'

class AISearch extends BaseModalMenu {
  constructor() {
    super()

    this.title = '学术搜索'
    this.iconSvg = `<svg style="fill:none" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-file-search"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M14 3v4a1 1 0 0 0 1 1h4" /><path d="M12 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v4.5" /><path d="M16.5 17.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0" /><path d="M18.5 19.5l2.5 2.5" /></svg>`
  }
  getValue(editor) {
    return <AISearchModal key={Date.now()} editor={editor}></AISearchModal>
  }
}

export default {
  key: 'AISearch',
  factory() {
    return new AISearch()
  },
}
