import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react'
import { Button, Popconfirm, message } from 'antd'
import { CloseOutlined } from '@ant-design/icons'
import { useDispatch } from 'react-redux'
import { setPracticeRandom } from '@/store/modules/editor'

import TopicItem from './topicItem'
import { addChapterTopic, getChapterTopic } from '../../utils/request'
import { clacTopicText } from '@/utils/common'

const InsertTopic = (props, ref) => {
  const {
    insertList,
    setInsertList,
    chooseList,
    setChooseList,
    practiceRandom = '',
    closePanel,
    chapterId,
    bookId
  } = props
  const dispatch = useDispatch()

  useImperativeHandle(ref, () => {
    return {}
  })

  // 插入的题库
  const [btnLoading, setBtnLoading] = useState(false)
  const [radioList, setRadioList] = useState([])
  const [checkboxList, setCheckboxList] = useState([])
  const [equalsList, setEqualsList] = useState([])
  const [pressList, setPressList] = useState([])
  const [textareaList, setTextAreaList] = useState([])

  // 删除
  const delConfirm = record => {
    const temp = JSON.parse(JSON.stringify(insertList))
    const newTemp = temp.filter(item => parseInt(item.choose_id) !== parseInt(record.choose_id))
    setInsertList(newTemp)
    setChooseList(newTemp)
  }

  // 添加
  const addChapterQuestion = async () => {
    setBtnLoading(true)

    const question_ids = insertList.map(item => item.choose_id)
    const data = await addChapterTopic({
      book_id: bookId,
      chapter_id: chapterId,
      question_ids,
      position: practiceRandom
    })
    if (data) {
      message.success('添加成功!')
      dispatch(setPracticeRandom({ practiceNum: '', practiceTitle: '' }))
      setBtnLoading(false)
      closePanel()
    }
  }

  useEffect(() => {
    if (insertList.length > 0) {
      const t1 = insertList.filter(item => parseInt(item.question_style) === 1)
      const t2 = insertList.filter(item => parseInt(item.question_style) === 2)
      const t3 = insertList.filter(item => parseInt(item.question_style) === 3)
      const t4 = insertList.filter(item => parseInt(item.question_style) === 4)
      const t5 = insertList.filter(item => parseInt(item.question_style) === 5)

      setRadioList(t1)
      setCheckboxList(t2)
      setEqualsList(t3)
      setPressList(t4)
      setTextAreaList(t5)
    } else {
      setRadioList([])
      setCheckboxList([])
      setEqualsList([])
      setPressList([])
      setTextAreaList([])
    }
  }, [insertList])

  return (
    <div className="practice-insert-container">
      <div className="practice-insert-topic list-topic-box">
        {radioList.length > 0 && (
          <div className="list-topic-container">
            <h4>{clacTopicText('radio')}. 单选题</h4>
            <div>
              {radioList.map((item, index) => {
                return (
                  <div className="topic-item" key={index}>
                    <div className="topic-info">
                      <TopicItem topic={item} index={index + 1} />
                    </div>
                    <div className="checkbox">
                      <Popconfirm
                        title="确认删除此题目吗?"
                        onConfirm={() => delConfirm(item)}
                        okText="确认"
                        cancelText="取消">
                        <Button type="link" icon={<CloseOutlined />} style={{ color: '#b83956' }}></Button>
                      </Popconfirm>
                    </div>
                  </div>
                )
              })}
            </div>
          </div>
        )}

        {checkboxList.length > 0 && (
          <div className="list-topic-container">
            <h4>{clacTopicText('checkbox', radioList)}. 多选题</h4>
            <div>
              {checkboxList.map((item, index) => {
                return (
                  <div className="topic-item" key={index}>
                    <div className="topic-info">
                      <TopicItem topic={item} index={index + 1} />
                    </div>
                    <div className="checkbox">
                      <Popconfirm
                        title="确认删除此题目吗?"
                        onConfirm={() => delConfirm(item)}
                        okText="确认"
                        cancelText="取消">
                        <Button type="link" icon={<CloseOutlined />} style={{ color: '#b83956' }}></Button>
                      </Popconfirm>
                    </div>
                  </div>
                )
              })}
            </div>
          </div>
        )}
        {equalsList.length > 0 && (
          <div className="list-topic-container">
            <h4>{clacTopicText('judge', radioList, checkboxList)}. 判断题</h4>
            <div>
              {equalsList.map((item, index) => {
                return (
                  <div className="topic-item" key={index}>
                    <div className="topic-info">
                      <TopicItem topic={item} index={index + 1} />
                    </div>
                    <div className="checkbox">
                      <Popconfirm
                        title="确认删除此题目吗?"
                        onConfirm={() => delConfirm(item)}
                        okText="确认"
                        cancelText="取消">
                        <Button type="link" icon={<CloseOutlined />} style={{ color: '#b83956' }}></Button>
                      </Popconfirm>
                    </div>
                  </div>
                )
              })}
            </div>
          </div>
        )}
        {pressList.length > 0 && (
          <div className="list-topic-container">
            <h4>{clacTopicText('fill', radioList, checkboxList, equalsList)}. 填空题</h4>
            <div>
              {pressList.map((item, index) => {
                return (
                  <div className="topic-item" key={index}>
                    <div className="topic-info">
                      <TopicItem topic={item} index={index + 1} />
                    </div>
                    <div className="checkbox">
                      <Popconfirm
                        title="确认删除此题目吗?"
                        onConfirm={() => delConfirm(item)}
                        okText="确认"
                        cancelText="取消">
                        <Button type="link" icon={<CloseOutlined />} style={{ color: '#b83956' }}></Button>
                      </Popconfirm>
                    </div>
                  </div>
                )
              })}
            </div>
          </div>
        )}
        {textareaList.length > 0 && (
          <div className="list-topic-container">
            <h4>{clacTopicText('textarea', radioList, checkboxList, equalsList, pressList)}. 简答题</h4>
            <div>
              {textareaList.map((item, index) => {
                return (
                  <div className="topic-item" key={index}>
                    <div className="topic-info">
                      <TopicItem topic={item} index={index + 1} />
                    </div>
                    <div className="checkbox">
                      <Popconfirm
                        title="确认删除此题目吗?"
                        onConfirm={() => delConfirm(item)}
                        okText="确认"
                        cancelText="取消">
                        <Button type="link" icon={<CloseOutlined />} style={{ color: '#b83956' }}></Button>
                      </Popconfirm>
                    </div>
                  </div>
                )
              })}
            </div>
          </div>
        )}
      </div>
      <div className="practice-insert-buttons">
        <Button type="primary" loading={btnLoading} onClick={addChapterQuestion}>
          确定
        </Button>
      </div>
    </div>
  )
}

export default forwardRef(InsertTopic)
