import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 分类列表
const getList = async (obj) => {
  const res = await axios.post('/book/category/getList', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// add
const categoryAdd = async (obj) => {
  const res = await axios.post('/book/category/add', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// info
const getInfoById = async (obj) => {
  const res = await axios.post('/book/category/getInfoById', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    return data;
  } else {
    message.error(msg);
    return false;
  }
};
// edit
const categoryEdit = async (obj) => {
  const res = await axios.post('/book/category/edit', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// del
const categoryDel = async (obj) => {
  const res = await axios.post('/book/category/del', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
// 修改排序
const changeSort = async (obj) => {
  const res = await axios.post('/book/category/changeSort', qs.stringify(obj));
  const code = get(res, 'data.code', 0);
  const data = get(res, 'data.data', []);
  const msg = get(res, 'data.message', '数据获取失败！');
  if (code === 200) {
    message.success(msg);
    return true;
  } else {
    message.error(msg);
    return false;
  }
};
export { getList, categoryAdd, getInfoById, categoryEdit, categoryDel, changeSort };
