import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 用户列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/members/members/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 详情
const getInfo = async (obj) => {
  try {
    const res = await axios.post('/members/members/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 订单记录
const getOrdersList = async (obj) => {
  try {
    const res = await axios.post('/members/members/getOrdersList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
//  积分记录
const getIntegralRecordList = async (obj) => {
  try {
    const res = await axios.post('/members/members/getIntegralRecordList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 优惠券记录
const getCouponList = async (obj) => {
  try {
    const res = await axios.post('/members/members/getCouponList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加
const addUser = async (obj) => {
  try {
    const res = await axios.post('/members/members/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改
const editUser = async (obj) => {
  try {
    const res = await axios.post('/members/members/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 删除
const delUser = async (obj) => {
  try {
    const res = await axios.post('/members/members/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export {
  getList,
  getInfo,
  getOrdersList,
  getIntegralRecordList,
  getCouponList,
  addUser,
  editUser,
  delUser,
};
