import axios from '@/utils/request.js';
import qs from 'qs';
import { message } from 'antd';
import { get } from 'lodash-es';

// oss
const getAliOSSSTSToken = async (obj) => {
  try {
    const res = await axios.post('/common/OssUpload/getUploadToken', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export { getAliOSSSTSToken };
