import axios from './request'
import { get } from 'lodash-es'
import { message } from 'antd'
// 统一上传
export const uploadFiles = async (obj) => {
  try {
    const res = await axios.post('/common/OssUpload/uploadFiles', obj, {
      headers: {
        'Content-Type': 'multipart/form-data',
      },
    })
    const code = get(res, 'data.code', 0)
    const data = get(res, 'data.data', [])
    const msg = get(res, 'data.message', '数据获取失败！')
    if (code === 200) {
      message.success(msg)
      return data
    } else {
      message.error(msg)
      return false
    }
  } catch (error) {
    return false
  }
}
