# React + Vite

This template provides a minimal setup to get React working in Vite with HMR and some ESLint rules.

Currently, two official plugins are available:

- [@vitejs/plugin-react](https://github.com/vitejs/vite-plugin-react/blob/main/packages/plugin-react/README.md) uses [Babel](https://babeljs.io/) for Fast Refresh
- [@vitejs/plugin-react-swc](https://github.com/vitejs/vite-plugin-react-swc) uses [SWC](https://swc.rs/) for Fast Refresh

## PC：

1. 预览时气泡的投影样式加深；
2. 修改默认字号为四号，18px;
3. 去掉选择图片时，查看链接的按钮；
4. 添加题目时，选择题选项正确答案的判断，单选和判断必须选一个，多选需要2个以上；
5. 修改画廊删除第一张图片无法正常删除，图片的标题和描述无法更新的问题，同时字段设置为不必须；
6. 为章头、节头、画廊（不包含行内）、扩展（不包含行内）、交互练习右上角添加关闭按钮，可以直接删除添加的内容。
7. 添加题目时，题干、答案、选项会过滤复制粘贴过来的样式，图片也会去除。
8. 添加交互练习时，可以进行分组，分组签名加上编号；同时题干和编号第一行对齐。

## APP:

1. 划线和高亮问题修复；
2. 画廊的图片可以点击打开放大，添加图片左右切换；
3. app端答题页也添加分组，同时题干和编号第一行对齐。
4. loading关闭的时机调整；
5. 阅读页样式修改

## 目录结构

````
ZIJING-HTML
├─.husky                            husky 代码提交规范
├─.vscode                           本地编辑器配置
├─dist                              npm run build 之后打包存放目录
├─formula-editor                    公式插件源代码
│
├─node_modules                      npm 包管下载目录
│
└─src                               主要代码存放目录
    ├─assets                        静态资源
    │  ├─fonts                      字体文件
    │  ├─images                     图片目录
    │  │  ├─editor
    │  │  ├─icon
    │  │  └─svg
    │  └─login                      验证码图片
    ├─common                        公共组件
    │  ├─dropDownCom                下拉菜单
    │  ├─editor-simple              编辑器
    │  ├─errorBoundary              错误边界信息
    │  ├─icon                       图标组件
    │  ├─iconfont                   图标字体
    │  ├─notFound                   404页面
    │  ├─notPermission              无权限页面
    │  ├─Pagination                 页码控制
    │  ├─TableCom                   表格组件
    │  ├─wangeditor-customer        编辑器
    │  └─websocket                  websocket hook
    ├─config                        路由组件配置
    ├─css
    ├─layout                        layout
    │  ├─components
    │  └─css
    ├─pages                         页面
    │  ├─advertisement              广告模块
    │  │  ├─adsense                 广告管理
    │  │  └─advert                  广告位管理
    │  ├─books                      书籍基本信息
    │  │  ├─audit                   书籍审核
    │  │  ├─classify                书籍分类
    │  │  ├─discussion              讨论互动
    │  │  ├─label                   书籍标签
    │  │  ├─management              写书管理
    │  │  ├─order-management        订单管理
    │  │  ├─question-bank           题库管理
    │  │  ├─sale                    书籍审核
    │  │  └─section                 写书管理 -- 章节
    │  ├─jurisdiction               权限管理
    │  │  ├─admin                   管理员管理
    │  │  └─role                    权限管理
    │  ├─member                     用户管理模块
    │  │  ├─detail                  用户详情
    │  │  ├─list                    用户列表
    │  │  └─userlevel               用户等级
    │  ├─setting                    系统设置模块
    │  │  ├─app-version             app版本管理
    │  │  ├─applied                 应用管理
    │  │  ├─coupon                  优惠券管理
    │  │  ├─feedback                意见反馈
    │  │  ├─help                    帮助中心
    │  │  ├─personalized-setting    个性化设置
    │  │  ├─point-management        积分管理
    │  │  └─sensitive               敏感词搜索
    │  ├─teacher                    老师管理模块
    │  │  └─query                   老师列表
    │  └─user-module                用户模块
    │      ├─login                  登录
    │      └─userInfo               个人中心
    ├─routes                        路由
    ├─store                         状态管理
    │  └─modules                    状态管理各模块
    └─utils                         工具函数和方法
    ```
````
