import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class ExpandRead {
  constructor() {
    this.title = '扩展阅读';
    this.iconSvg = `<svg width="48px" height="48px" viewBox="0 0 48 48" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标拓展</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-136, -1198)">
            <rect id="矩形" stroke="#666666" stroke-width="3" fill="#FFFFFF" x="137.5" y="1199.5" width="45" height="45" rx="3"></rect>
            <g id="拓展" transform="translate(145, 1208)" fill="#666666" fill-rule="nonzero">
                <path d="M29,11.3518923 L29,2.2164013 C28.9981053,0.994066004 28.0132647,0.00364224218 26.7978198,0.00173681164 L17.7138266,0.00173681164 C17.2775903,-0.0219772576 16.8640118,0.198589435 16.6388006,0.575061782 C16.4135894,0.951534129 16.4135894,1.42232257 16.6388006,1.79879492 C16.8640118,2.17526727 17.2775903,2.39583396 17.7138266,2.37211989 L24.9397303,2.37211989 L15.9348779,11.2861445 C15.4741417,11.7496364 15.4741417,12.5009529 15.9348779,12.9644449 C16.3953604,13.4254916 17.1397942,13.4254916 17.6002767,12.9644449 L26.6395381,4.03311825 L26.6395381,11.3518923 C26.6396388,12.0073395 27.1680167,12.5386307 27.8197691,12.5386307 C28.4715214,12.5386307 29,12.0073395 29,11.3518923 Z M1.18027069,16.4560019 C0.866057977,16.4559965 0.564813972,16.5819964 0.343278844,16.8060865 C0.121743716,17.0301766 -0.00179239696,17.3338558 1.96568521e-05,17.6498445 L1.96568521e-05,26.7853355 C0.00193443835,28.0076708 0.98677507,28.9980946 2.20221993,29 L11.2862132,29 C11.9123697,28.9659617 12.4027407,28.445434 12.4027407,27.8148085 C12.4027407,27.1841829 11.9123697,26.6636552 11.2862132,26.6296169 L4.06030947,26.6296169 L13.0754846,17.7017507 C13.3998016,17.4098644 13.5380641,16.962166 13.4352357,16.5368648 C13.3324074,16.1115636 13.0051784,15.7776902 12.5838043,15.6681454 C12.1624303,15.5586005 11.7153045,15.6911644 11.4204085,16.013069 L2.35706074,24.9582373 L2.35706074,17.6498445 C2.35981427,17.3341762 2.23704802,17.0304843 2.01605793,16.8062919 C1.79506783,16.5820995 1.49417161,16.4559897 1.18027069,16.4560019 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button';
  }
  getValue(editor) {
    return 'hello, 音频';
  }
  isActive(editor) {
    return false; // or true
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if (this.isDisabled(editor)) {
      return;
    }
    editor.emit('ExpandReadClick');
  }
}

export default {
  key: 'ExpandRead', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ExpandRead(); // 把 `YourMenuClass` 替换为你菜单的 class
  },
};

export { ExpandRead };
