import { useState, useEffect } from 'react'
import { SendOutlined } from '@ant-design/icons'
import { Drawer, Input, Button, message, Select } from 'antd'
import MarkdownRender from '@/components/markdownRender'
import { useAI } from '@/hooks/useAI'

// import normalAvatar from '@/assets/images/icon-normal-avatar.png'

import './AIChatDrawer.less'

const AIChatDrawer = (props) => {
  const selectText = props.editor.getSelectionText()
  const [open, setOpen] = useState(true)

  const { ai, setAI, options, messages, post, isLoading } = useAI()

  const [value, setValue] = useState(selectText) // 输入值

  useEffect(() => {
    if (selectText) {
      targetChat()
    }

    return () => {
      setValue('')
    }
  }, [selectText])

  const element = document.querySelector('#chat-content')

  useEffect(() => {
    element?.scrollTo(0, 999999)
  }, [messages, element])

  // 提交对话
  const targetChat = async () => {
    if (value) {
      post({ content: value })
      setValue('')
    } else {
      message.error('请输入对话内容！')
    }
  }

  return (
    <Drawer
      open={open}
      width="600px"
      title="AI对话"
      destroyOnClose
      onClose={() => setOpen(false)}
      rootClassName="ai-drawer-wrapper"
      className="ai-drawer-container">
      <div className="ai-drawer-content">
        <div className="ai-chat-container">
          <div className="chat-content" id="chat-content">
            <div className="chat-content-padd">
              {messages.map((item, index) => {
                return (
                  <div className={`chat-content-item`} key={index}>
                    {item.role === 'assistant' && (
                      <div className="inside">
                        <div className="ai-in-content">
                          <div className="ask-content">
                            <MarkdownRender>{item.content}</MarkdownRender>
                          </div>
                        </div>
                      </div>
                    )}
                    {item.role === 'user' && (
                      <div className="inside inside-user">
                        <div className="user-in-content">
                          <div className="ask-content">{item.content}</div>
                        </div>
                      </div>
                    )}
                  </div>
                )
              })}
            </div>
          </div>
        </div>
        <Select value={ai} options={options} onChange={setAI} style={{ marginTop: '10px' }}></Select>
        <div className="ai-chat-ask">
          <div className="text">
            <Input.TextArea
              value={value}
              defaultValue={value}
              allowClear
              disabled={isLoading}
              onChange={(e) => setValue(e.target.value)}
              placeholder="请输入内容"
              style={{ height: '80px', resize: 'none' }}></Input.TextArea>
          </div>
          <div className="button">
            <Button
              type="primary"
              icon={<SendOutlined />}
              loading={isLoading}
              size="large"
              onClick={targetChat}></Button>
          </div>
        </div>
      </div>
    </Drawer>
  )
}

export default AIChatDrawer
