import { DomEditor, SlateTransforms } from '@wangeditor/editor';
import icon_tooltip_editor from '@/assets/images/editor/icon_tooltip_editor.png';
import { h } from 'snabbdom';
import '../utils/iconfont';

const withChapterFormulaNode = (editor) => {
  const { isInline, isVoid, normalizeNode } = editor;
  const newEditor = editor;

  newEditor.isInline = (elem) => {
    const type = DomEditor.getNodeType(elem);
    if (type === 'chapterFormula') return true; // 设置为 inline
    return isInline(elem);
  };

  newEditor.isVoid = (elem) => {
    const type = DomEditor.getNodeType(elem);
    if (type === 'chapterFormula') return true; // 设置为 void
    return isVoid(elem);
  };

  // 重新 normalize
  newEditor.normalizeNode = ([node, path]) => {
    const type = DomEditor.getNodeType(node);
    if (type !== 'chapterFormula') {
      // 未命中 chapterHeader ，执行默认的 normalizeNode
      return normalizeNode([node, path]);
    }

    const topLevelNodes = newEditor.children || [];
    const nextNode = topLevelNodes[path[0]] || {};
    if (nextNode.type === 'paragraph') {
      const lastChild = nextNode.children[nextNode.children.length -1];
      if (lastChild.type === 'chapterExpandReadSimple') {
        SlateTransforms.insertNodes(newEditor, { type: 'span', children: [{ text: '' }] }, {
          at: path, // 在 link-card 后面插入
        });
      }
    }
  };

  return newEditor; // 返回 newEditor ，重要！！！
};

// 在编辑器中渲染新元素
// 定义 renderElem 函数
const renderChapterFormula = (elem, children, editor) => {
  // 获取“附件”的数据，参考上文 myResume 数据结构
  const { formulaHtml } = elem;
  // 附件元素 vnode
  const attachVnode = h(
    // HTML tag
    'span',
    // HTML 属性、样式、事件
    {
      props: {
        // HTML 属性，驼峰式写法
        contentEditable: false,
        className: 'chapter-formula',
        innerHTML: formulaHtml
      },
      dataset: {
        formulaHtml: encodeURI(formulaHtml)
      },
      on: {
        click(ev) {
          ev.stopPropagation();
          ev.preventDefault();
          
        } /* 其他... */,
      },
    },
    // 子节点
    [h('span', {}, [''])],
  );
  return attachVnode;
};
const renderElemConf = {
  type: 'chapterFormula',
  renderElem: renderChapterFormula,
};

// 把新元素转换为 HTML
const chapterFormulaToHtml = (elem, childrenHtml) => {
  // 获取附件元素的数据
  const { formulaHtml } = elem;
  // 生成 HTML 代码
  const html = `<span class="chapter-formula" data-w-e-type="chapterFormula" data-formulaHtml="${encodeURI(formulaHtml)}">${formulaHtml}</span>`;

  return html;
};
const chapterFormulaElemToHtmlConf = {
  type: 'chapterFormula', // 新元素的 type ，重要！！！
  elemToHtml: chapterFormulaToHtml,
};

// 解析新元素 HTML 到编辑器
const parseChapterFormulaHtml = (domElem, children, editor) => {
  // 从 DOM element 中获取“附件”的信息
  const formulaHtml = domElem.getAttribute('data-formulaHtml') || '';
  
  // 生成“附件”元素（按照此前约定的数据结构）
  const myResume = {
    type: 'chapterFormula',
    formulaHtml: decodeURI(formulaHtml),
    children: [{ text: '' }], // void node 必须有 children ，其中有一个空字符串，重要！！！
  };
  return myResume;
};
const parseChapterFormulaConf = {
  selector: 'span[data-w-e-type="chapterFormula"]', // CSS 选择器，匹配特定的 HTML 标签
  parseElemHtml: parseChapterFormulaHtml,
};

const chapterToolTipModule = {
  editorPlugin: withChapterFormulaNode,
  renderElems: [renderElemConf],
  elemsToHtml: [chapterFormulaElemToHtmlConf],
  parseElemsHtml: [parseChapterFormulaConf],
};

export default chapterToolTipModule;
export {
  withChapterFormulaNode,
  renderElemConf,
  chapterFormulaElemToHtmlConf,
  parseChapterFormulaConf,
};
