import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';

// 获取题目列表
const getTopicList = async (obj) => {
  try {
    const res = await axios.post('/book/question/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 获取题目分类列表
const getTopicTypeList = async (obj) => {
  try {
    const res = await axios.post('/book/question/type/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 添加练习
const addChapterTopic = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 添加练习
const getChapterTopic = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/getQuestionList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除练习
const delChapterTopic = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/removeQuestion', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 添加气泡
const addChapterTooltip = async (obj) => {
  try {
    const res = await axios.post('/book/bubble/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除气泡
const delChapterTooltip = async (obj) => {
  try {
    const res = await axios.post('/book/bubble/removeBubble', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加扩展
const addExpandRead = async (obj) => {
  try {
    const res = await axios.post('/book/extend/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除扩展
const delExpandRead = async (obj) => {
  try {
    const res = await axios.post('/book/extend/removeExtend', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 扩展详情
const expandReadInfo = async (obj) => {
  try {
    const res = await axios.post('/book/extend/info', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除扩展
const addGallery = async (obj) => {
  try {
    const res = await axios.post('/book/gallery/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 删除画廊
const delGallery = async (obj) => {
  try {
    const res = await axios.post('/book/gallery/removeGallery', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 获取OSS ststoekn
const getAliOSSSTSToken = async (obj) => {
  try {
    const res = await axios.post('/common/OssUpload/getUploadToken', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '获取OSS令牌失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 保存历史详情
const getRecordInfo = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/getRecordInfo', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 保存历史记录
const getRecordList = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/getRecordList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

export {
  getTopicList,
  getTopicTypeList,
  addChapterTopic,
  delChapterTopic,
  getChapterTopic,
  addChapterTooltip,
  delChapterTooltip,
  addExpandRead,
  delExpandRead,
  expandReadInfo,
  addGallery,
  delGallery,
  getAliOSSSTSToken,
  getRecordInfo,
  getRecordList,
};
