import React, { useEffect, useState } from 'react'
import { Table, Row, DatePicker, Form, Modal, Switch } from 'antd'
const { RangePicker } = DatePicker
import PaginationCom from '@/common/Pagination'
import { getPositionList, changeStatus } from './request'
import TableCom from '@/common/TableCom/index'
import { useSelector } from 'react-redux'
const Adsense = () => {
  const [data, setData] = useState([])
  const [page_size, setpage_size] = useState(10)
  const [page, setPage] = useState(1)
  const [total, setTotal] = useState(0)
  const [loading, setLoading] = useState(true)
  const [isEdit, setIsEdit] = useState(false)
  const [delMoadal, setDelModal] = useState(false)
  const [form] = Form.useForm()
  const [swichDisabled, setSwichDisabled] = useState(false)
  // 获取操作权限
  const { operationPermissionsList } = useSelector(state => state.user)
  const handleStatus = async (status, id) => {
    const bool = await changeStatus({ id, status: status ? '1' : '0' })
    bool && init()
  }
  const onClose = () => {
    setIsEdit(false)
  }
  const submitForm = obj => {
    console.log(obj)
  }
  const delSuccess = () => {
    setDelModal(false)
  }
  const init = async (obj = {}) => {
    setLoading(true)
    const { total, list } = await getPositionList({ page, page_size, ...obj })
    setTotal(total)
    setData(list)
    setLoading(false)
  }

  useEffect(() => {
    setSwichDisabled(!operationPermissionsList.includes('/advertisement/adsense/changeStatus'))
  })

  const columns = [
    {
      title: '广告位位置',
      key: 'position_name',
      dataIndex: 'position_name'
    },
    {
      title: '广告位大小',
      key: 'pic_size',
      dataIndex: 'pic_size'
    },
    {
      title: '状态',
      key: 'status',
      dataIndex: 'status',
      render(_, { status, id }) {
        return <Switch defaultChecked={status} onChange={ev => handleStatus(ev, id)} disabled={swichDisabled} />
      }
    }
  ]
  return (
    <div className="classify">
      {TableCom({ columns, data, loading })}
      <Modal
        mask={false}
        centered
        open={delMoadal}
        onOk={delSuccess}
        onCancel={() => setDelModal(false)}
        footer={(_, { OkBtn, CancelBtn }) => {
          return (
            <Row justify={'center'} className="delModal">
              <Space>
                <CancelBtn />
                <OkBtn />
              </Space>
            </Row>
          )
        }}
        okText="确认">
        <p style={{ textAlign: 'center', padding: '50px 0 30px', fontSize: 16 }}>分类将永久删除，是否继续?</p>
      </Modal>
      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
      />
    </div>
  )
}

export default Adsense
