import { Drawer, Form, Input, Select, Button, Space, App } from 'antd'
const { TextArea } = Input
import { addCouponRecord } from '../api'

export default function SendCouponDrawer({ couponList = [], ...rest }) {
  const { message } = App.useApp()
  const [form] = Form.useForm()

  const onFinish = async values => {
    const res = await addCouponRecord(values)
    if (res.data.err.msg) {
      message.error(res.data.err.title)
    } else {
      message.success(res.message)
      rest.onClose && rest.onClose()
    }
  }
  const onClose = () => {
    form.resetFields()
    rest.onClose && rest.onClose()
  }
  return (
    <Drawer title="优惠券发放" placement="right" {...rest} onClose={onClose}>
      <Form form={form} onFinish={onFinish} labelCol={{ span: 6 }} autoComplete="off">
        <Form.Item name="phone" label="用户手机号" rules={[{ required: true, message: '请输入用户手机号' }]}>
          <TextArea
            placeholder="请输入用户手机号，用英文逗号隔开，每次最多100个"
            autoSize={{ minRows: 5, maxRows: 8 }}></TextArea>
        </Form.Item>
        <Form.Item name="id" label="发放优惠券" rules={[{ required: true, message: '请选择优惠券' }]}>
          <Select placeholder="请选择优惠券">
            {couponList.map(item => (
              <Select.Option value={item.id} key={item.id}>
                {item.name}
              </Select.Option>
            ))}
          </Select>
        </Form.Item>
        <Form.Item wrapperCol={{ offset: 5, span: 16 }} style={{ textAlign: 'center' }}>
          <Space size={20}>
            <Button onClick={onClose}>取消</Button>
            <Button type="primary" htmlType="submit">
              提交
            </Button>
          </Space>
        </Form.Item>
      </Form>
    </Drawer>
  )
}
