import axios from '@/utils/request.js';
import qs from 'qs';
import { get } from 'lodash-es';
import { message } from 'antd';
// 用户信息
const getUserInfo = async (obj) => {
  try {
    const res = await axios.post('/user/user/getUserInfo', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 获取角色已选权限
const getPowerByRoleId = async (obj) => {
  try {
    const res = await axios.post('/user/role/getPowerByRoleId', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 章节列表
const getAllList = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/getAllList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return {
        code,
        data,
      };
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加章节
const chapterAdd = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      // message.success('添加成功');
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 章节详情
const getInfoById = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/getInfoById', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改章节
const chapterEdit = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 删除章节
const chapterDel = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 拖拽章节排序
const dragOrder = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/chapter/dragOrder', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 获取章节内容
const getInfoByChapterId = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/getInfoByChapterId', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加章节内容
const sectionAdd = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 修改章节内容
const sectionEdit = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/edit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      // message.success(msg);
      return true;
    } else {
      message.error(msg);
      return { code, msg, data };
    }
  } catch (error) {
    return false;
  }
};
// 获取章节的题库列表
const getQuestionList = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/getQuestionList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 移除课后题
const questionDel = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/del', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 添加课后题
const questionAdd = async (obj) => {
  try {
    const res = await axios.post('/book/chapter/question/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 发布审核
const release = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/release', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 模板列表
const templateGetList = async (obj) => {
  try {
    const res = await axios.post('/book/template/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 模板导入
const templateImport = async (obj) => {
  try {
    const res = await axios.post('/book/template/import', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
// 书籍导入
const teacherImport = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/import', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};

// 保存历史记录
const getRecordList = async (obj) => {
  try {
    const res = await axios.post('/book/teacher/section/getRecordList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return false;
  }
};
export {
  getAllList,
  chapterAdd,
  getInfoById,
  chapterEdit,
  chapterDel,
  dragOrder,
  getInfoByChapterId,
  sectionAdd,
  sectionEdit,
  getQuestionList,
  questionDel,
  questionAdd,
  release,
  templateGetList,
  templateImport,
  teacherImport,
  getRecordList,
  getPowerByRoleId,
  getUserInfo,
};
