import { lazy } from 'react'
import { Navigate } from 'react-router-dom'
import { authComponent } from './lazyLoadAndDelay' // 添加一个固定的延迟时间，以便你可以看到加载状态

import Layout from '@/layout/index'

const baseRouter = [
  {
    path: '/',
    element: authComponent(Layout),
    children: [
      {
        index: true,
        element: <Navigate to="/books/management" />
      },
      // 书籍管理
      {
        path: 'books',
        title: '书籍管理',
        Component: lazy(() => import('@/pages/books/index')),
        children: [
          {
            index: true,
            element: <Navigate to="management" />
          },
          {
            path: 'management',
            title: '写书管理',
            Component: lazy(() => import('@/pages/books/management/index')),
            children: [
              {
                index: true,
                Component: lazy(() => import('@/pages/books/management/list/index'))
              },
              {
                path: 'list',
                Component: lazy(() => import('@/pages/books/management/list/index'))
              },
              {
                path: 'add-edit',
                Component: lazy(() => import('@/pages/books/management/addedit/index'))
              },
              {
                path: 'chapter',
                Component: lazy(() => import('@/pages/books/section/index'))
              }
            ]
          },
          {
            path: 'audit',
            title: '书籍审核',
            Component: lazy(() => import('@/pages/books/audit/index')),
            children: [
              {
                index: true,
                Component: lazy(() => import('@/pages/books/audit/table'))
              },
              {
                path: '/books/audit/dataset',
                Component: lazy(() => import('@/pages/books/audit/table'))
              },
              {
                path: '/books/audit/detail',
                Component: lazy(() => import('@/pages/books/audit/detail'))
              }
            ]
          },
          {
            path: '/books/classify',
            title: '书籍分类',
            Component: lazy(() => import('@/pages/books/classify/index'))
          },
          {
            path: '/books/label',
            title: '书籍标签',
            Component: lazy(() => import('@/pages/books/label/index'))
          },
          {
            path: '/books/sale',
            title: '在售书籍',
            Component: lazy(() => import('@/pages/books/sale/index')),
            children: [
              {
                index: true,
                Component: lazy(() => import('@/pages/books/sale/table'))
              },
              {
                path: '/books/sale/dataset',
                Component: lazy(() => import('@/pages/books/sale/table'))
              },
              {
                path: '/books/sale/detail',
                Component: lazy(() => import('@/pages/books/sale/edit'))
              },
              {
                path: '/books/sale/discussP',
                Component: lazy(() => import('@/pages/books/sale/discussList/index'))
              },
              {
                path: '/books/sale/discuss-detail',
                Component: lazy(() => import('@/pages/books/sale/discussDetail/index'))
              }
            ]
          },
          {
            path: '/books/question-bank',
            title: '题库管理',
            Component: lazy(() => import('@/pages/books/question-bank/index'))
          },
          {
            path: '/books/discussion',
            title: '讨论互动',
            Component: lazy(() => import('@/pages/books/discussion/index'))
          },
          {
            path: '/books/order-management',
            title: '订单管理',
            Component: lazy(() => import('@/pages/books/order-management/index')),
            children: [
              {
                index: true,
                Component: lazy(() => import('@/pages/books/order-management/tab/table'))
              },
              {
                path: '/books/order-management/dataset',
                Component: lazy(() => import('@/pages/books/order-management/tab/table'))
              },
              {
                path: '/books/order-management/sale-statistics',
                Component: lazy(() => import('@/pages/books/order-management/tab/salesStatistics'))
              }
            ]
          },
          {
            path: '/books/design',
            title: '在线设计',
            Component: lazy(() => import('@/pages/books/design/index'))
          }
        ]
      },

      // 用户管理
      {
        path: 'member',
        title: '用户管理',
        Component: lazy(() => import('@/pages/member/index')),
        children: [
          {
            index: true,
            element: <Navigate to="/member/list" />
          },
          {
            path: '/member/list',
            title: '用户管理',
            Component: lazy(() => import('@/pages/member/list/index')),
            children: [
              {
                index: true,
                Component: lazy(() => import('@/pages/member/list/list'))
              },
              {
                path: '/member/list/query',
                Component: lazy(() => import('@/pages/member/list/list'))
              },
              {
                path: '/member/list/detail',
                Component: lazy(() => import('@/pages/member/detail/index'))
              }
            ]
          },
          {
            path: '/member/userlevel',
            title: '用户等级',
            Component: lazy(() => import('@/pages/member/userlevel/index'))
          }
        ]
      },
      // 广告管理
      {
        path: 'advertisement',
        title: '广告管理',
        Component: lazy(() => import('@/pages/advertisement/index')),
        children: [
          {
            index: true,
            element: <Navigate to="/advertisement/advert" />
          },
          {
            path: '/advertisement/advert',
            title: '广告管理',
            Component: lazy(() => import('@/pages/advertisement/advert/index'))
          },
          {
            path: '/advertisement/adsense',
            title: '广告位管理',
            Component: lazy(() => import('@/pages/advertisement/adsense/index'))
          }
        ]
      },
      // 系统设置
      {
        path: 'setting',
        title: '系统设置',
        Component: lazy(() => import('@/pages/setting/index')),
        children: [
          {
            index: true,
            element: <Navigate to="/setting/applied" />
          },
          {
            path: '/setting/help',
            title: '帮助中心',
            Component: lazy(() => import('@/pages/setting/help/index')),
            children: [
              {
                index: true,
                element: <Navigate to="/setting/help/list" />
              },
              {
                path: '/setting/help/list',
                Component: lazy(() => import('@/pages/setting/help/table'))
              },
              {
                path: '/setting/help/addedit',

                Component: lazy(() => import('@/pages/setting/help/addedit/index'))
              }
            ]
          },
          {
            path: '/setting/applied',
            title: '应用管理',
            Component: lazy(() => import('@/pages/setting/applied/index'))
          },
          {
            path: '/setting/personalized-setting',
            title: '个性化设置',
            Component: lazy(() => import('@/pages/setting/personalized-setting/index'))
          },
          {
            path: '/setting/point-management',
            title: '积分管理',
            Component: lazy(() => import('@/pages/setting/point-management/index'))
          },
          {
            path: '/setting/app-version',
            title: 'APP版本管理',
            Component: lazy(() => import('@/pages/setting/app-version/index'))
          },
          {
            path: '/setting/coupon',
            title: '优惠卷管理',
            Component: lazy(() => import('@/pages/setting/coupon/index'))
          },
          {
            path: '/setting/sensitive',
            title: '敏感词搜索',
            Component: lazy(() => import('@/pages/setting/sensitive/index'))
          },
          {
            path: '/setting/feedback',
            title: '意见反馈',
            Component: lazy(() => import('@/pages/setting/feedback/index'))
          }
        ]
      },

      // 权限管理
      {
        path: 'jurisdiction',
        title: '权限管理',
        Component: lazy(() => import('@/pages/jurisdiction/index')),
        children: [
          {
            index: true,
            element: <Navigate to="/jurisdiction/role" />
          },
          {
            path: '/jurisdiction/admin',
            title: '管理员管理',
            Component: lazy(() => import('@/pages/jurisdiction/admin/index'))
          },
          {
            path: '/jurisdiction/role',
            title: '角色管理',
            Component: lazy(() => import('@/pages/jurisdiction/role/index'))
          }
        ]
      },
      // 老师管理
      {
        path: 'teacher',
        title: '老师管理',
        Component: lazy(() => import('@/pages/teacher/index')),
        children: [
          {
            index: true,
            element: <Navigate to="/teacher/list" />
          },
          {
            path: '/teacher/list',
            title: '老师管理',
            Component: lazy(() => import('@/pages/teacher/query/index'))
          }
        ]
      },
      {
        path: 'userinfo',
        Component: lazy(() => import('@/pages/user-module/userInfo'))
      },
      {
        path: 'editor',
        Component: lazy(() => import('@/pages/editor/index'))
      }
    ]
  },
  {
    path: 'login',
    Component: lazy(() => import('@/pages/user-module')),
    children: [
      {
        index: true,
        Component: lazy(() => import('@/pages/user-module/login'))
      }
    ]
  },
  {
    path: 'student/book',
    Component: lazy(() => import('@/pages/student/book/index'))
  },
  { path: '*', element: <Navigate to="/" /> }
]

export default baseRouter
