import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  token: '',
  menuRouter: [],
  menuListRouter: [],
  userInfo: {},
  operationPermissionsList: [],
  treeChapter: {
    saveBookId: '',
    saveChapterId: '',
  },
};

export const user = createSlice({
  // 命名空间
  name: 'user',
  // 初始化状态值
  initialState,
  // 定义 reducers 并生成关联的操作
  reducers: {
    // 设置用户个人信息
    setUserInfo(state, { payload }) {
      state.userInfo = payload;
    },
    // 设置用户token
    setToken(state, { payload }) {
      state.token = payload;
    },
    // 设置动态路由菜单
    setMenuRouter(state, { payload }) {
      state.menuRouter = payload;
    },
    // 设置动态路由菜单
    setMenuListRouter(state, { payload }) {
      state.menuListRouter = payload;
    },
    // 设置操作权限
    setOperationPermissionsList(state, { payload }) {
      state.operationPermissionsList = payload;
    },
    // 设置写书管理里面的章节信息
    setTreeChapter(state, { payload }) {
      state.treeChapter = { ...payload };
    },
  },
});

export const { setUserInfo, setToken, setMenuRouter, setMenuListRouter, setOperationPermissionsList, setTreeChapter } = user.actions;

export default user.reducer;
