import DropListMenu from '../menu-constructors/DropListMenu'
import $ from '../../utils/dom-core'
import { createMemuElem } from '../../utils/util'
import Editor from '../../editor/index'
import OperatorList from '../common/InlineBlockList'

class Physical extends DropListMenu {
  constructor(editor: Editor) {
    const $elem = $(createMemuElem('E'))
    const presetList = new OperatorList(editor.menusConfig.physical)
    const presetConf = {
      title: editor.t('fe.e'),
      list: presetList.getItemList(),
      clickHandler: (value: string) => {
        this.command(value)
      },
    }
    super($elem, editor, presetConf)
  }
}

export default Physical
