import { Suspense } from 'react'
import { ErrorBoundary } from 'react-error-boundary'
import { Button } from 'antd'
import './App.less'

import { GetRoutesDynamic } from '@/routes/index'

function fallbackRender({ error, resetErrorBoundary }) {
  return (
    <div role="alert">
      <p>出错啦:</p>
      <pre style={{ color: 'red' }}>{error.message}</pre>
      <Button type="link" onClick={resetErrorBoundary}>
        Try again
      </Button>
    </div>
  )
}
function App() {
  return (
    <ErrorBoundary fallbackRender={fallbackRender}>
      <Suspense>
        <GetRoutesDynamic />
      </Suspense>
    </ErrorBoundary>
  )
}

export default App
