import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor'

class ChapterItem {
  constructor() {
    this.title = '节头'
    this.iconSvg = `<svg width="22px" height="23px" viewBox="0 0 22 23" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-430, -688)">
            <g id="右侧章节目录" transform="translate(335, 592)"></g>
            <g id="icon_节头" transform="translate(430, 688)" fill="#666666" fill-rule="nonzero">
                <path d="M15.9477225,5 L6.05227743,5 C5.60261702,5 5.23809524,5.40679504 5.23809524,5.90860215 C5.23809524,6.41040926 5.60261702,6.8172043 6.05227743,6.8172043 L15.9477225,6.8172043 C16.3973829,6.8172043 16.7619047,6.41040926 16.7619047,5.90860215 C16.7619047,5.40679504 16.3973829,5 15.9477225,5 L15.9477225,5 Z M5.23809524,13.5967742 L5.23809524,9.33333333 C5.23809524,8.94732786 5.51849661,8.6344086 5.86438923,8.6344086 L16.1356107,8.6344086 C16.4815033,8.6344086 16.7619047,8.94732786 16.7619047,9.33333333 L16.7619047,13.5967742 C16.7619047,13.9827797 16.4815033,14.2956989 16.1356107,14.2956989 L5.86438923,14.2956989 C5.51849661,14.2956989 5.23809524,13.9827797 5.23809524,13.5967742 L5.23809524,13.5967742 Z M6.05227743,16.1827957 L15.9477225,16.1827957 C16.2386018,16.1827957 16.5073854,16.3559743 16.652825,16.6370968 C16.7982647,16.9182193 16.7982647,17.2645764 16.652825,17.5456989 C16.5073854,17.8268214 16.2386018,18 15.9477225,18 L6.05227743,18 C5.60261702,18 5.23809524,17.593205 5.23809524,17.0913978 C5.23809524,16.5895907 5.60261702,16.1827957 6.05227743,16.1827957 L6.05227743,16.1827957 Z" id="形状"></path>
                <path d="M3.76129032,0 C1.68392258,0 0,1.67406135 0,3.7392638 L0,19.2607362 C0,21.3259387 1.68392258,23 3.76129032,23 L18.2387097,23 C20.3160774,23 22,21.3259387 22,19.2607362 L22,3.7392638 C22,1.67406135 20.3160774,0 18.2387097,0 L3.76129032,0 Z M1.84516129,3.7392638 C1.84516129,2.68719018 2.70301935,1.83435583 3.76129032,1.83435583 L18.2387097,1.83435583 C19.2969806,1.83435583 20.1548387,2.68719018 20.1548387,3.7392638 L20.1548387,19.2607362 C20.1548387,20.3128098 19.2969806,21.1656442 18.2387097,21.1656442 L3.76129032,21.1656442 C2.70301935,21.1656442 1.84516129,20.3128098 1.84516129,19.2607362 L1.84516129,3.7392638 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem)
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if (this.isDisabled(editor)) {
      return
    }
    editor.emit('ChapterItemMenuClick')
  }
}

export default {
  key: 'ChapterItem', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ChapterItem() // 把 `YourMenuClass` 替换为你菜单的 class
  }
}

export { ChapterItem }
