import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class ChapterTitle {
  constructor() {
    this.title = '章头'
    this.iconSvg = `<svg width="22px" height="23px" viewBox="0 0 22 23" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-382, -688)">
            <g id="右侧章节目录" transform="translate(335, 592)"></g>
            <g id="icon_章头" transform="translate(382, 688)" fill="#666666" fill-rule="nonzero">
                <path d="M5.23809529,9.90957447 L5.23809529,5.69148936 C5.23809529,5.30959033 5.51849666,5 5.86438928,5 L16.1356107,5 C16.3017142,5 16.4610145,5.07285313 16.5784675,5.20253254 C16.6959204,5.33221196 16.7619047,5.50809498 16.7619047,5.69148936 L16.7619047,9.90957447 C16.7619047,10.2914735 16.4815033,10.6010638 16.1356107,10.6010638 L5.86438928,10.6010638 C5.51849666,10.6010638 5.23809529,10.2914735 5.23809529,9.90957447 L5.23809529,9.90957447 Z M6.05227747,12.4680851 L15.9477225,12.4680851 C16.2386018,12.4680851 16.5073854,12.6394213 16.652825,12.9175532 C16.7982647,13.195685 16.7982647,13.5383576 16.652825,13.8164894 C16.5073854,14.0946212 16.2386018,14.2659574 15.9477225,14.2659574 L6.05227747,14.2659574 C5.60261707,14.2659574 5.23809529,13.86349 5.23809529,13.3670213 C5.23809529,12.8705525 5.60261707,12.4680851 6.05227747,12.4680851 L6.05227747,12.4680851 Z M15.9477225,16.2021277 L6.05227747,16.2021277 C5.76139818,16.2021277 5.49261463,16.3734639 5.34717498,16.6515957 C5.20173533,16.9297276 5.20173533,17.2724001 5.34717498,17.5505319 C5.49261463,17.8286638 5.76139818,18 6.05227747,18 L15.9477225,18 C16.3973829,18 16.7619047,17.5975326 16.7619047,17.1010638 C16.7619047,16.6045951 16.3973829,16.2021277 15.9477225,16.2021277 L15.9477225,16.2021277 Z" id="形状"></path>
                <path d="M3.76129032,0 C1.68392258,0 0,1.67406135 0,3.7392638 L0,19.2607362 C0,21.3259387 1.68392258,23 3.76129032,23 L18.2387097,23 C20.3160774,23 22,21.3259387 22,19.2607362 L22,3.7392638 C22,1.67406135 20.3160774,0 18.2387097,0 L3.76129032,0 Z M1.84516129,3.7392638 C1.84516129,2.68719018 2.70301935,1.83435583 3.76129032,1.83435583 L18.2387097,1.83435583 C19.2969806,1.83435583 20.1548387,2.68719018 20.1548387,3.7392638 L20.1548387,19.2607362 C20.1548387,20.3128098 19.2969806,21.1656442 18.2387097,21.1656442 L3.76129032,21.1656442 C2.70301935,21.1656442 1.84516129,20.3128098 1.84516129,19.2607362 L1.84516129,3.7392638 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false;
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('ChapterTitleClick');
  }
}

export default {
  key: 'ChapterTitle', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ChapterTitle() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  ChapterTitle
}