class ConvertTooltipType {
  constructor() {
    this.title = '气泡转换'
    this.iconSvg = `<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path fill="currentColor" d="M8 0L3 5h3v11h4V5h3L8 0z"/></svg>`
    this.tag = 'button'
  }

  // eslint-disable-next-line no-unused-vars
  getValue(editor) {
    return ''
  }

  // eslint-disable-next-line no-unused-vars
  isActive(editor) {
    return false
  }

  // eslint-disable-next-line no-unused-vars
  isDisabled(editor) {
    return false
  }

  exec(editor) {
    // 获取当前 HTML
    const html = editor.getHtml()
    console.log(html)
    if (!html) {
      return
    }

    // 使用正则表达式批量将文字气泡（tooltipType="1"）转换为图标气泡（tooltipType="2"）
    // 匹配 data-tooltipType="1"、data-tooltipType='1'、data-tooltip-type="1"、data-tooltip-type='1' 等格式
    const htmlConverted = html
      .replace(/data-tooltipType="1"/gi, 'data-tooltipType="2"')
      .replace(/data-tooltipType='1'/gi, "data-tooltipType='2'")
      .replace(/data-tooltip-type="1"/gi, 'data-tooltip-type="2"')
      .replace(/data-tooltip-type='1'/gi, "data-tooltip-type='2'")

    console.log(htmlConverted)

    // 如果内容有变化，设置回去
    if (htmlConverted !== html) {
      // 保存当前选区

      // 设置处理后的 HTML
      editor.setHtml(htmlConverted)
    }
  }
}

export default {
  key: 'ConvertTooltipType', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new ConvertTooltipType()
  },
}

export { ConvertTooltipType }
