import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class FormulaAuto {
  constructor() {
    this.title = '公式'
    this.iconSvg = `<svg width="17px" height="19px" viewBox="0 0 17 19" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-681.000000, -1150.000000)">
            <g id="右侧章节目录" transform="translate(551.000000, 592.000000)">
                <rect id="边框" stroke="#CCCCCC" fill="#EEEEEE" opacity="0.302679084" x="0.5" y="50.5" width="259" height="666"></rect>
                <g id="高级模块" transform="translate(14.000000, 520.000000)" fill="#666666" fill-rule="nonzero">
                    <g id="公式" transform="translate(117.000000, 38.000000)">
                        <polyline id="路径" points="8.41216216 10.2384587 9.63956198 9 8.41216216 7.76154128 2.46272134 1.75887489 15 1.75205207 15 0 0.00163094129 0.008234433 0.00163094129 1.76028651 7.18476235 9 0 16.248889 0 17.9917656 14.9983691 18 14.9983691 16.2479479 2.4610904 16.2411251 8.41216216 10.2384587"></polyline>
                    </g>
                </g>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false;
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('FormulaMenuClick');
  }
}

export default {
  key: 'FormulaAuto', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new FormulaAuto() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  FormulaAuto
}