import { DomEditor, SlateRange } from '@wangeditor/editor'

class GalleryAutoOnline {
  constructor() {
    this.title = '在线画廊'
    this.iconSvg = `<svg version="1.1" id="图层_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
<style type="text/css">
	.st0{fill:#AF1C40;}
</style>
<path class="st0" d="M179.7,56.1c-4.9-2.9-10.9-2.9-15.8,0l-5.5,3.2v-5.4c0-12.1-9.9-22-22-22h-99c-12.2,0-22,9.8-22.1,22V143
	c0,12.2,9.9,22,22.1,22.1h99c12.2,0,22-9.9,22-22.1v-5.4l5.5,3.2c7.6,4.4,17.2,1.8,21.6-5.8c1.4-2.4,2.1-5.1,2.1-7.9V69.8
	C187.6,64.1,184.6,58.9,179.7,56.1z M146.4,143c0,5.5-4.5,10-10,10.1h-99c-5.6,0-10.1-4.5-10.1-10.1V53.9c0-5.5,4.5-10,10-10h99
	c5.5,0,10,4.5,10,10L146.4,143L146.4,143z M175.6,127.1c0,2.1-1.7,3.8-3.8,3.8c-0.7,0-1.3-0.2-1.9-0.5l-11.5-6.6V73.1l11.5-6.6
	c1.8-1,4.2-0.4,5.2,1.4c0.3,0.6,0.5,1.2,0.5,1.9V127.1z"/>
<g>
	<path class="st0" d="M110.6,104.9c0,0.5-0.1,1-0.4,1.5c-0.1,0.2-0.3,0.4-0.4,0.6l-5.4,5.4c-0.5,0.5-1.2,0.8-1.9,0.8c0,0,0,0,0,0
		c-0.7,0-1.4-0.3-1.9-0.7c-0.9-0.8-1.8-1.5-2.8-2.1c-3.2-2-7-3.1-10.8-3.1c-5.2,0-10.2,2-14.1,5.5c-0.4,0.3-0.9,0.5-1.5,0.5
		c-0.6,0-1.2-0.3-1.7-0.7L64,107c-0.5-0.5-0.8-1.3-0.8-2c0-0.8,0.3-1.5,0.9-2c2.7-2.5,5.7-4.4,9-5.9c4.3-2,9-3,13.8-3
		c8.5,0,16.6,3.1,22.8,8.9c0.2,0.2,0.4,0.4,0.5,0.6C110.4,104,110.5,104.4,110.6,104.9z"/>
	<path class="st0" d="M86.9,127.8c-3.6,0-6.6-3-6.6-6.6s3-6.6,6.6-6.6s6.6,3,6.6,6.6S90.5,127.8,86.9,127.8z"/>
	<path class="st0" d="M126,89.4c0,0.8-0.3,1.5-0.8,2l-5.4,5.4c-0.5,0.5-1.2,0.8-2,0.8c-0.7,0-1.4-0.3-1.9-0.8
		c-1.8-1.7-3.7-3.2-5.8-4.6c-6.9-4.5-15-7-23.3-7c-11,0-21.3,4.2-29.3,11.7c0,0,0,0,0,0c-0.4,0.4-1,0.6-1.7,0.6
		c-0.5,0-1.1-0.1-1.8-0.6c-0.1-0.1-0.3-0.2-0.4-0.3l-5.2-5.2c-0.5-0.5-0.8-1.3-0.8-2c0-0.8,0.3-1.5,0.9-2c1.1-1,2.2-2,3.3-2.9
		c9.9-8,22.1-12.3,35-12.3c14.3,0,28,5.4,38.3,15.3C125.7,88,126,88.7,126,89.4z"/>
</g>
</svg>`
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some((elem) => {
      const type = DomEditor.getNodeType(elem)
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if (this.isDisabled(editor)) {
      return
    }
    editor.emit('GalleryOnlineMenuClick')
  }
}

export default {
  key: 'GalleryAutoOnline', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new GalleryAutoOnline() // 把 `YourMenuClass` 替换为你菜单的 class
  }
}

export { GalleryAutoOnline }
