import { DomEditor, SlateTransforms, SlateRange } from '@wangeditor/editor';

class Practice {
  constructor() {
    this.title = '交互练习'
    this.iconSvg = `<svg width="22px" height="23px" viewBox="0 0 22 23" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <title>图标</title>
    <g id="页面-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="图标" transform="translate(-486, -688)">
            <g id="右侧章节目录" transform="translate(335, 592)"></g>
            <g id="考试、练习" transform="translate(486, 688)" fill="#666666" fill-rule="nonzero">
                <path d="M16.3047839,0 C19.3049321,0 21.7368827,2.45169047 21.7368827,5.47619047 L21.7368827,17.5238095 C21.7368827,20.5483095 19.3049321,23 16.3047839,23 L5.44058643,23 C2.44043828,23 0.00848764583,20.5483095 0.00848764583,17.5238095 L0.00848764583,5.47619047 C0.00848764583,2.45169047 2.44043828,0 5.44058643,0 L16.3047839,0 Z M16.3047839,1.91666668 L5.44058643,1.91666668 C3.53976348,1.91666668 1.98003225,3.43357508 1.91189505,5.34859525 L1.90972222,5.47619047 L1.90972222,17.5238095 C1.90972222,19.4400612 3.4144172,21.0124526 5.31401852,21.0811429 L5.44058643,21.0833333 L16.3047839,21.0833333 C18.2056069,21.0833333 19.7653381,19.5664249 19.8334753,17.6514048 L19.8356481,17.5238095 L19.8356481,5.47619047 C19.8356481,3.55993877 18.3309532,1.9875474 16.4313519,1.91885714 L16.3047839,1.91666668 Z" id="形状"></path>
                <path d="M14.6751543,5.88690475 C15.1847732,5.88713574 15.6035525,6.29245554 15.6245379,6.8057752 C15.6455232,7.31909487 15.2612483,7.75777999 14.7533765,7.80028571 L14.6751543,7.80357143 L7.07021606,7.80357143 C6.56059719,7.80334044 6.14181786,7.39802065 6.12083249,6.88470098 C6.09984712,6.37138131 6.48412212,5.93269619 6.99199384,5.89019047 L7.07021606,5.88690475 L14.6751543,5.88690475 Z M13.9515988,10.3308333 C14.2810596,9.9404355 14.8569116,9.88049615 15.2585467,10.1947956 C15.6601817,10.509095 15.7453944,11.0863504 15.4519444,11.5049286 L15.3987099,11.5739286 L10.9541667,16.8299762 C10.6343875,17.2078436 10.0812227,17.2767779 9.6797963,16.9887857 L9.61135185,16.935119 L6.4509568,14.198119 C6.06316729,13.8649126 6.00494002,13.2827291 6.31894354,12.8781885 C6.63294706,12.4736479 7.20750007,12.3906329 7.62157407,12.6899762 L7.68947532,12.7441905 L10.1263148,14.853619 L13.9515988,10.3302857 L13.9515988,10.3308333 Z" id="形状"></path>
            </g>
        </g>
    </g>
</svg>`;
    this.tag = 'button'
  }
  getValue(editor) {
    return 'hello, 图片, , , 图片'
  }
  isActive(editor) {
    return false;
  }
  isDisabled(editor) {
    const { selection } = editor
    if (selection === null) return true
    if (SlateRange.isExpanded(selection)) return true // 选区非折叠，禁用

    const selectedElems = DomEditor.getSelectedElems(editor)

    // const hasVoidElem = selectedElems.some(elem => editor.isVoid(elem))
    // if (hasVoidElem) return true // 选中了 void 元素，禁用

    // eslint-disable-next-line array-callback-return
    const hasPreElem = selectedElems.some(elem => {
      const type = DomEditor.getNodeType(elem);
      // 代码块 引用 表格 禁用
      if (type === 'pre' || type === 'blockquote' || type === 'table' || type === 'table-row' || type === 'table-cell') return true
    })
    if (hasPreElem) return true // 选中了 pre 原则，禁用

    return false
  }
  exec(editor, value) {
    // editor.insertText(value) // value 即 this.getValue(editor) 的返回值
    if(this.isDisabled(editor)){
      return;
    }
    editor.emit('PracticeMenuClick');
  }
}

export default {
  key: 'Practice', // 定义 menu key ：要保证唯一、不重复（重要）
  factory() {
    return new Practice() // 把 `YourMenuClass` 替换为你菜单的 class
  },
}

export {
  Practice
}