import React, { useState, forwardRef, useImperativeHandle, useRef } from 'react'
import { Input, InputNumber } from 'antd'
import '../index.less'

const PaddingSpace = (props, ref) => {
  const { editorNodes, editor } = props
  const [inputValue1, setInputValue1] = useState('')
  const [inputValue2, setInputValue2] = useState('')
  const [inputValue3, setInputValue3] = useState('')
  const timeDebonceRef = useRef()

  const InpoutValueChange1 = value => {
    setInputValue1(value)
    changeIt()
  }
  const InpoutValueChange2 = value => {
    setInputValue2(value)
  }
  const InpoutValueChange3 = value => {
    setInputValue3(value)
  }

  const changeIt = () => {
    clearTimeout(timeDebonceRef.current)
    timeDebonceRef.current = setTimeout(() => {}, 500)

    if (editorNodes) {
    } else {
    }
  }

  useImperativeHandle(ref, () => {
    return {
      inputValue1,
      inputValue2,
      inputValue3
    }
  })

  return (
    <div className="custom-bar-box-input">
      <div className="box">
        <div className="customer-box-input-item">
          <p>
            <InputNumber controls={false} id="padding_1" value={inputValue1} onChange={InpoutValueChange1} />
          </p>
          <p className="text">段前间距</p>
        </div>
        <div className="customer-box-input-item">
          <p>
            <InputNumber controls={false} id="padding_2" value={inputValue2} onChange={InpoutValueChange2} />
          </p>
          <p className="text">段后间距</p>
        </div>
        <div className="customer-box-input-item">
          <p>
            <InputNumber controls={false} id="padding_3" value={inputValue3} onChange={InpoutValueChange3} />
          </p>
          <p className="text">行距</p>
        </div>
      </div>
    </div>
  )
}

export default forwardRef(PaddingSpace)
