import { useEffect, useState } from 'react'
import { Modal, Input, Button, Flex, Spin, Form, App } from 'antd'
import { useAIEdit } from '@/hooks/useBaiduAI'
import { addType, addQuestion } from '@/api/ai'
import store from '@/store/index'

const { TextArea } = Input

const actionMap = {
  1: {
    name: '单选题',
    prompt: `请根据以下内容，理解之后，出一道单选题，正确答案只能有一个，要求如下：
1、包含四个选项。
2、给出正确答案。
输出的文本内容包含：
1、题目类型：
2、分类：
3、题干：
4、题目解析：
5、题目选项_1：
6、题目选项答案_1：正确为“是”，错误为“否”
7、题目选项_2：
8、题目选项答案_2：正确为“是”，错误为“否”
9、题目选项_3：
10、题目选项答案_3：正确为“是”，错误为“否”
11、题目选项_4：
12、题目选项答案_1：正确为“是”，错误为“否”
待理解内容：`
  },
  2: {
    name: '多选题',
    prompt: `请根据以下内容，理解之后，出一道多选题，要求如下：
1、包含四个选项。
2、给出正确答案。
输出的文本内容包含：
1、题目类型：
2、分类：
3、题干：
4、题目解析：
5、题目选项_1：
6、题目选项答案_1：正确为“是”，错误为“否”
7、题目选项_2：
8、题目选项答案_2：正确为“是”，错误为“否”
9、题目选项_3：
10、题目选项答案_3：正确为“是”，错误为“否”
11、题目选项_4：
12、题目选项答案_1：正确为“是”，错误为“否”
待理解内容：`
  },
  3: {
    name: '判断题',
    prompt: `请根据以下内容，理解之后，出一道判断题，要求如下：
1、包含四个选项。
2、给出正确答案。
输出的文本内容包含：
1、题目类型：
2、分类：
3、题干：
4、题目解析：
5、题目选项_1：
6、题目选项答案_1：正确为“是”，错误为“否”
7、题目选项_2：
8、题目选项答案_2：正确为“是”，错误为“否”
待理解内容：`
  }
}

export default function AIQuestionModal({ editor, action }) {
  const { message } = App.useApp()
  const [isModalOpen, setIsModalOpen] = useState(true)
  const [content, setContent] = useState('')
  const { text, fetch, isLoading } = useAIEdit()
  const actionText = actionMap[action]?.name
  const [selectionText, setSelectionText] = useState('')
  useEffect(() => {
    const selection = editor.getSelectionText()
    if (selection) {
      setSelectionText(selection)
      setContent(selection)
      fetch({ messages: [{ role: 'user', content: actionMap[action].prompt + selection }] })
    }
  }, [action, editor, fetch])

  useEffect(() => {
    if (text) setQuestion(generateQuestionData(text))
  }, [text])

  const handleFetch = () => {
    fetch({ messages: [{ role: 'user', content: actionMap[action].prompt + selectionText }] })
  }
  const [question, setQuestion] = useState({
    question_style: action,
    titles: '',
    analysis: '',
    question_list: []
  })
  // 获取A-Z的字母
  function getAlphabet(i) {
    return String.fromCharCode(65 + i)
  }
  // 生成试题数据
  function generateQuestionData(str) {
    // 初始化返回对象
    const result = {
      titles: '',
      analysis: '',
      answers: '',
      question_list: []
    }

    // 使用正则表达式提取各个部分
    const titleMatch = str.match(/题干：(.+?)\s/)
    const analysisMatch = str.match(/题目解析：(.+?)\s/)

    // 设置基本信息
    if (titleMatch) result.titles = titleMatch[1]
    if (analysisMatch) result.analysis = analysisMatch[1]

    // 提取选项和答案
    const options = []
    let currentIndex = 1

    // eslint-disable-next-line no-constant-condition
    while (true) {
      const optionMatch = str.match(new RegExp(`题目选项_${currentIndex}：(.+?)\\s`))
      const answerMatch = str.match(new RegExp(`题目选项答案_${currentIndex}：(是|否)`))
      console.log(optionMatch, answerMatch, currentIndex)
      if (!optionMatch || !answerMatch) break
      const option = { option: optionMatch[1], correct: answerMatch[1] === '是', abc: getAlphabet(currentIndex - 1) }
      if (option.correct) result.answers += option.abc
      options.push(option)

      currentIndex++
    }

    result.question_list = options

    return result
  }

  const { user } = store.getState()
  // 提交
  const handlePrimary = async () => {
    const { data } = await addType({ name: `${user.treeChapter.book_name}/${user.treeChapter.chapter_name}` })
    const res = await addQuestion({
      ...question,
      book_id: user.treeChapter.book_id,
      type_id: data.type_id,
      question_style: action,
      question_list: JSON.stringify(question.question_list)
    })
    message.success(res.message)
    setIsModalOpen(false)
  }

  return (
    <Modal
      title="AI创建试题"
      open={isModalOpen}
      footer={null}
      width={800}
      onOk={handlePrimary}
      onCancel={() => setIsModalOpen(false)}>
      <Spin spinning={isLoading}>
        <Form labelCol={{ span: 2 }}>
          <Form.Item label="题目类型">{actionText}</Form.Item>
          <Form.Item label="参考内容">
            <TextArea autoSize={{ minRows: 4 }} value={content} onChange={e => setContent(e.target.value)} />
          </Form.Item>
          <Form.Item label="题干">
            <div style={{ lineHeight: '32px' }}>
              {question.titles}
              {question.question_list.map(item => {
                return (
                  <div key={item.abc}>
                    {item.abc}.{item.option}
                  </div>
                )
              })}
            </div>
          </Form.Item>
          <Form.Item label="正确答案">{question.answers}</Form.Item>
          <Form.Item label="题目解析">
            <div style={{ lineHeight: '32px' }}>{question.analysis}</div>
          </Form.Item>
        </Form>
      </Spin>
      <br />
      <Flex gap="small" justify="center">
        <Button onClick={() => setIsModalOpen(false)}>取消</Button>
        <Button type="primary" onClick={handleFetch}>
          重新出题
        </Button>
        <Button type="primary" onClick={handlePrimary}>
          确定
        </Button>
      </Flex>
    </Modal>
  )
}
