import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react'
import { Input } from 'antd'

const inCorrect = [
  'A',
  'B',
  'C',
  'D',
  'E',
  'F',
  'G',
  'H',
  'I',
  'J',
  'K',
  'L',
  'M',
  'N',
  'O',
  'P',
  'Q',
  'R',
  'S',
  'T',
  'U',
  'V',
  'W',
  'X',
  'Y',
  'Z'
]

const TopicItem = (props, ref) => {
  const { topic, index, preview = false } = props
  const [recordInfo, setRecordInfo] = useState({})
  const [choose, setChoose] = useState(false)
  const [chooseAnswer, setChooseAnswer] = useState([])
  const [isMap, setIsMap] = useState(false)

  useEffect(() => {
    if (Object.entries(topic).length) {
      let temp = {}
      for (const key in topic) {
        if (key === 'question_list') {
          try {
            temp[key] = JSON.parse(topic[key])
          } catch (e) {
            temp[key] = topic[key]
          }
        } else {
          temp[key] = topic[key]
        }
      }

      if (temp.question_style === 1 || temp.question_style === 2 || temp.question_style === 3) {
        setChoose(true)
      }
      if (temp.question_list instanceof Array && temp.question_list.length > 0) {
        setIsMap(true)
        let an = []
        temp.question_list.forEach((item, index) => {
          if (item.correct && (item.correct === 'true' || item.correct === true)) {
            an.push(inCorrect[index])
          }
        })
        setChooseAnswer(an)
      }
      setRecordInfo(temp)
    }
  }, [topic])

  useImperativeHandle(ref, () => {
    return {}
  })

  return (
    <div className="topic-item-info">
      {Object.entries(recordInfo).length && (
        <>
          <div className="index">{index}.</div>
          <div className="topic">
            {/* <div>{recordInfo.titles}</div> */}
            <div className="topic-choose-title" dangerouslySetInnerHTML={{ __html: recordInfo.titles }}></div>
            {[1, 2, 3].includes(parseInt(recordInfo.question_style)) && (
              <div className="topic-choose">
                {choose &&
                  isMap &&
                  recordInfo &&
                  recordInfo.question_list &&
                  recordInfo.question_list instanceof Array &&
                  recordInfo.question_list.map((item, cindex) => {
                    return (
                      <div
                        className="topic-choose-item"
                        key={cindex}
                        dangerouslySetInnerHTML={{
                          __html: `${inCorrect[cindex]}.  ` + item.option
                        }}></div>
                    )
                  })}
              </div>
            )}

            {preview && (
              <div className="notes-preivew">
                {recordInfo.question_style === 5 && (
                  <div className="textarea">
                    <Input.TextArea autoSize={{ minRows: 3, maxRows: 4 }} />
                  </div>
                )}
              </div>
            )}

            <div className="answer">
              <strong>答案: </strong>
              {[1, 2, 3].includes(recordInfo.question_style) ? (
                <span>{chooseAnswer.join(' ')}</span>
              ) : (
                <span dangerouslySetInnerHTML={{ __html: recordInfo.answers }}></span>
              )}
            </div>
          </div>
        </>
      )}
    </div>
  )
}

export default forwardRef(TopicItem)
