export default [
  // 书籍管理
  {
    name: 'books',
    key: '/books',
    title: '书籍管理',
    component: 'books/index',
  },
  {
    name: 'books-classify',
    key: '/books/classify',
    title: '书籍分类',
    component: 'books/classify/index',
  },
  {
    name: 'books-audit',
    key: '/books/audit',
    title: '书籍审核',
    component: 'books/audit/index',
    isChild: true,
  },
  {
    name: 'books-label',
    key: '/books/label',
    title: '书籍标签',
    component: 'books/label/index',
  },
  {
    name: 'books-management',
    key: '/books/management',
    title: '写书管理',
    component: 'books/management/index',
    isChild: true,
  },
  {
    name: 'books-sale',
    key: '/books/sale',
    title: '在售书籍',
    component: 'books/sale/index',
    isChild: true,
  },
  {
    name: 'books-question-bank',
    key: '/books/question-bank',
    title: '题库管理',
    component: 'books/question-bank/index',
  },
  {
    name: 'books-discussion',
    key: '/books/discussion',
    title: '讨论互动',
    component: 'books/discussion/index',
  },
  {
    name: 'order-management',
    key: '/books/order-management',
    title: '订单管理',
    component: 'books/order-management/index',
    isChild: true,
  },
  {
    name: 'books-design',
    key: '/books/design',
    title: '在线设计',
    component: 'books/design/index',
  },
  // 用户管理
  {
    name: 'member',
    key: '/member',
    title: '用户管理',
    component: 'member/index',
  },
  {
    name: 'memberlist',
    key: '/member/list',
    title: '用户管理',
    component: 'member/list/index',
    isChild: true,
  },
  {
    name: 'userlevel',
    key: '/member/userlevel',
    title: '用户等级',
    component: 'member/userlevel/index',
  },
  // 广告管理
  {
    name: 'advertisement',
    key: '/advertisement',
    title: '广告管理',
    component: 'advertisement/index',
  },
  {
    name: 'advert',
    key: '/advertisement/advert',
    title: '广告管理',
    component: 'advertisement/advert/index',
  },
  {
    name: 'adsense',
    key: '/advertisement/adsense',
    title: '广告位管理',
    component: 'advertisement/adsense/index',
  },
  // 系统设置
  {
    name: 'setting',
    key: '/setting',
    title: '系统设置',
    component: 'setting/index',
  },
  {
    name: 'settingHelp',
    key: '/setting/help',
    title: '帮助中心',
    component: 'setting/help/index',
    isChild: true,
  },
  {
    name: 'applied',
    key: '/setting/applied',
    title: '应用管理',
    component: 'setting/applied/index',
  },
  {
    name: 'personalized',
    key: '/setting/personalized-setting',
    title: '个性化设置',
    component: 'setting/personalized-setting/index',
  },
  {
    name: 'point',
    key: '/setting/point-management',
    title: '积分管理',
    component: 'setting/point-management/index',
  },
  {
    name: 'appversion',
    key: '/setting/app-version',
    title: 'APP版本管理',
    component: 'setting/app-version/index',
  },
  {
    name: 'coupon',
    key: '/setting/coupon',
    title: '优惠卷管理',
    component: 'setting/coupon/index',
  },
  {
    name: 'sensitive',
    key: '/setting/sensitive',
    title: '敏感词搜索',
    component: 'setting/sensitive/index',
  },
  {
    name: 'feedback',
    key: '/setting/feedback',
    title: '意见反馈',
    component: 'setting/feedback/index',
  },
  // 权限管理
  {
    name: 'jurisdiction',
    key: '/jurisdiction',
    title: '权限管理',
    component: 'jurisdiction/index',
  },
  {
    name: 'jurisdictionadmin',
    key: '/jurisdiction/admin',
    title: '管理员管理',
    component: 'jurisdiction/admin/index',
  },
  {
    name: 'jurisdictionrole',
    key: '/jurisdiction/role',
    title: '角色管理',
    component: 'jurisdiction/role/index',
  },
  // 老师管理
  {
    name: 'teacher',
    key: '/teacher',
    title: '老师管理',
    component: 'teacher/index',
  },
  {
    name: 'teacherlist',
    key: '/teacher/list',
    title: '老师管理',
    component: 'teacher/query/index',
  },
]

const childThirdRoutes = {
  // 写书管理
  '/books/management': [
    {
      path: '/books/management/list',
      key: '/books/management/list',
      name: 'managementlist',
      meta: { title: '' },
      hidden: true,
      component: 'books/management/list/index',
    },
    {
      path: '/books/management/add-edit',
      key: '/books/management/add-edit',
      name: 'management-addedit',
      meta: { title: '' },
      hidden: true,
      back: true,
      component: 'books/management/addedit/index',
    },
    {
      path: '/books/management/chapter',
      key: '/books/management/chapter',
      name: 'management-chapter',
      meta: { title: '' },
      hidden: true,
      back: true,
      component: 'books/section/index',
    },
  ],
  // 书籍基本信息
  '/books/audit': [
    {
      path: '/books/audit/dataset',
      key: '/books/audit/dataset',
      name: 'dataset',
      meta: {
        title: '',
      },
      hidden: true,
      component: 'books/audit/table',
    },
    {
      path: '/books/audit/detail',
      key: 'dataset',
      meta: {
        title: '',
      },
      hidden: true,
      back: true,
      component: 'books/audit/detail',
    },
  ],
  // 书籍审核
  '/books/sale': [
    {
      path: '/books/sale/dataset',
      key: '/books/sale/dataset',
      name: 'dataset',
      meta: {
        title: '',
      },
      hidden: true,
      component: 'books/sale/table',
    },
    {
      path: '/books/sale/detail',
      key: '/books/sale/detail',
      name: 'detail',
      meta: {
        title: '',
      },
      hidden: true,
      back: true,
      component: 'books/sale/edit',
    },
    {
      path: '/books/sale/discussP',
      key: '/books/sale/discussP',
      name: 'discussP',
      meta: {
        title: '',
      },
      hidden: true,
      back: true,
      component: 'books/sale/discussList/index',
    },
    {
      path: '/books/sale/discuss-detail',
      key: '/books/sale/discuss-detail',
      meta: {
        title: '',
      },
      hidden: true,
      back: true,
      component: 'books/sale/discussDetail/index',
    },
  ],
  // 订单管理
  '/books/order-management': [
    {
      path: '/books/order-management/dataset',
      key: '/books/order-management/dataset',
      name: 'dataset',
      meta: {
        title: '',
      },
      hidden: true,
      component: 'books/order-management/tab/table',
    },
    {
      path: '/books/order-management/sale-statistics',
      key: '/books/order-management/sale-statistics',
      name: 'sale-statistics',
      meta: {
        title: '',
      },
      hidden: true,
      component: 'books/order-management/tab/salesStatistics',
    },
  ],
  // 用户管理
  '/member/list': [
    {
      path: '/member/list/query',
      key: '/member/list/query',
      name: 'member-query',
      hidden: true,
      meta: {},
      component: 'member/list/list',
    },
    {
      path: '/member/list/detail',
      key: '/member/list/detail',
      name: 'member-detail',
      hidden: true,
      meta: {},
      component: 'member/detail/index',
    },
  ],
  // 帮助中心
  '/setting/help': [
    {
      path: '/setting/help/list',
      key: '/setting/help/list',
      anme: 'help-list',
      meta: {},
      hidden: true,
      component: 'setting/help/table',
    },
    {
      path: '/setting/help/addedit',
      pakeyth: '/setting/help/addedit',
      name: 'help-addedit',
      meta: {},
      hidden: true,
      back: true,
      component: 'setting/help/addedit/index',
    },
  ],
}

export { childThirdRoutes }
