import { useState, useEffect } from 'react'
import { getTeacherList } from '@/api/user'

export function useTeachers() {
  const [teachers, setTeachers] = useState([])
  const [loading, setLoading] = useState(true)
  const [error, setError] = useState(null)

  useEffect(() => {
    const fetchTeachers = async () => {
      try {
        const response = await getTeacherList({ page_size: 40 })
        setTeachers(response.data.list)
      } catch (err) {
        setError(err)
      } finally {
        setLoading(false)
      }
    }

    fetchTeachers()
  }, [])

  return { teachers, loading, error }
}
