import { Button } from 'antd'
import { LoginOutlined } from '@ant-design/icons'
import { useNavigate } from 'react-router-dom'
import { logout } from '@/api/base'
import Cookies from 'js-cookie'

export default function Logout() {
  const navigator = useNavigate()
  const handleLogout = async () => {
    await logout()
    Cookies.remove('TGC', { domain: '.ezijing.com' })
    localStorage.clear()
    navigator('/login')
  }
  return <Button style={{ border: 'none', background: '#f6f6f6' }} icon={<LoginOutlined />} onClick={handleLogout}></Button>
}
