import React, { useEffect, useState } from 'react';
import { Table, Input, Button, Row, Col, Space, DatePicker, Image } from 'antd';
const { RangePicker } = DatePicker;
import { useNavigate } from 'react-router-dom';
import PaginationCom from '@/common/Pagination';
import { getCommentList } from '../request';
import reset from '@/assets/images/icon/reset.png';
import filter from '@/assets/images/icon/filter.png';

import reload from '@/assets/images/icon/reload.png';
import { useLocation } from 'react-router-dom';
import dayjs from 'dayjs';
import { get } from 'lodash-es';
import TableCom from '@/common/TableCom/index';
const DiscussList = () => {
  const [data, setData] = useState([]);
  const { state = {} } = useLocation();
  const book_id = get(state, 'id', '');
  const name = get(state, 'name', '');
  const navigate = useNavigate();
  const [page_size, setpage_size] = useState(10);
  const [page, setPage] = useState(1);
  const [total, setTotal] = useState(0);
  const [loading, setLoading] = useState(true);
  const [id, setId] = useState(0);
  const [filterObj, setfilterObj] = useState({
    book_id: null,
    title: '',
    user_name: '',
    start_time: '',
    end_time: '',
  });
  const [dateVal, setDateVal] = useState('');
  // 重置
  const handleReset = () => {
    setfilterObj({ name: '', authors: '', audit_status: '1' });
    setDateVal('');
    init();
  };
  const init = async (obj = {}) => {
    setLoading(true);
    const { total, list } = await getCommentList({ page, page_size, ...obj, book_id });
    setTotal(total);
    setData(list);
    setLoading(false);
  };
  // 过滤
  const handleFilter = (flag, val) => {
    if (flag == 'startandend') {
      let val2 = val || [];
      filterObj['start_time'] = parseInt(
        new Date(dayjs(val2[0]).format('YYYY-MM-DD') + ' 00:00:00').getTime() / 1000,
      );
      const endDate = new Date(dayjs(val2[1])).getDate();
      const endTime = parseInt(
        new Date(dayjs(val2[1]).format('YYYY-MM-') + endDate + ' 23:59:59').getTime() / 1000,
      );
      filterObj['end_time'] = endTime;
      setDateVal(val);
      if (!val2.length) {
        delete filterObj['start_time'];
        delete filterObj['end_time'];
      }
    } else {
      filterObj[flag] = val;
    }
    for (const key in filterObj) {
      if (!filterObj[key]) {
        delete filterObj[key];
      }
    }
    setfilterObj({ ...filterObj });
    if (!val) init(filterObj);
  };

  const columns = [
    {
      title: '话题',
      key: 'title',
      dataIndex: 'title',
      width: 200,
    },
    {
      title: '发起人',
      key: 'name',
      dataIndex: 'name',
    },
    {
      title: '发起时间',
      key: 'create_time',
      dataIndex: 'create_time',
    },
    {
      title: '操作',
      key: 'handle',
      dataIndex: 'handle',
      render: (_, { id }) => {
        return (
          <Space>
            <Button
              onClick={() =>
                navigate('/books/sale/discuss-detail', {
                  state: { id, name, book_id },
                })
              }
            >
              查看详情
            </Button>
          </Space>
        );
      },
    },
  ];
  return (
    <div>
      <Row justify={'space-between'}>
        <Col>
          <Space>
            <label htmlFor='title'>话题</label>
            <Input
              autoComplete='off'
              placeholder='请输入话题'
              id='title'
              value={filterObj.title}
              onChange={(ev) => handleFilter('title', ev.target.value)}
            ></Input>
            <label htmlFor='user_name'>发起人</label>
            <Input
              autoComplete='off'
              placeholder='请输入发起人'
              id='user_name'
              value={filterObj.user_name}
              onChange={(ev) => handleFilter('user_name', ev.target.value)}
            ></Input>
            <label htmlFor='createTime'>发起时间</label>
            <RangePicker
              id='createTime'
              value={filterObj.startandend}
              onChange={(ev) => handleFilter('startandend', ev)}
            ></RangePicker>
            <Button
              type='primary'
              ghost
              icon={
                <span
                  style={{
                    display: 'inline-block',
                    width: '11px',
                    height: '10px',
                    pointerEvents: 'none',
                  }}
                >
                  <Image src={reset} />
                </span>
              }
              onClick={handleReset}
            >
              重置
            </Button>
            <Button
              type='primary'
              ghost
              onClick={() => {
                setPage(1);
                Object.values(filterObj).some((item) => item) ? init(filterObj) : init();
              }}
              icon={
                <span
                  style={{
                    display: 'inline-block',
                    width: '13px',
                    height: '12px',
                    pointerEvents: 'none',
                  }}
                >
                  <Image src={filter} />
                </span>
              }
            >
              筛选
            </Button>
            <Button
              type='primary'
              ghost
              icon={
                <span
                  style={{
                    display: 'inline-block',
                    width: '10px',
                    height: '12px',
                    pointerEvents: 'none',
                  }}
                >
                  <Image src={reload} />
                </span>
              }
              onClick={() =>
                Object.values(filterObj).some((item) => item) ? init(filterObj) : init()
              }
            >
              刷新
            </Button>
          </Space>
        </Col>
        <Col></Col>
      </Row>
      <br />
      {/* <Table
        scroll={{
          y: 600,
          x: true,
        }}
        columns={columns}
        rowKey={(record) => record.id}
        dataSource={data}
        loading={loading}
        pagination={false}
      ></Table> */}

      {TableCom({ columns, loading, data })}
      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
        filterObj={filterObj}
      />
    </div>
  );
};

export default DiscussList;
