import axios from '@/utils/request.js';
import qs from 'qs';
import { message } from 'antd';
import { get } from 'lodash-es';
// 获取积分设置信息
const getIntegral = async (obj) => {
  try {
    const res = await axios.post('/system/config/getIntegral', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 设置积分开关
const integralSet = async (obj) => {
  try {
    const res = await axios.post('/system/config/integralSet', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 修改积分配置
const integralEdit = async (obj) => {
  try {
    const res = await axios.post('/system/config/integralEdit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 充值积分
const integralAdd = async (obj) => {
  try {
    const res = await axios.post('/members/integral/add', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 3000) {
      message.warning('优惠券已过期');
      return true;
    }

    // 先检查空手机号的情况，如果满足就跳出后续错误提示
    if (
      data.err.msg === '  手机号：' &&
      data.suc.title &&
      !data.suc.title.includes('充值成功（0）')
    ) {
      if (data.suc.msg !== '') {
        message.success(`${data.suc.msg}充值成功`, 10);
      }
      // message.error(`空手机号充值失败`, 10);
      return true;
    }

    // 接下来处理其他非空错误消息和成功消息

    if (data.suc.title && !data.suc.title.includes('充值成功（0）')) {
      if (data.suc.msg !== '') {
        message.success(`${data.suc.msg}充值成功`, 10);
      }
    }
    if (data.err.title && !data.err.title.includes('充值失败（0）')) {
      if (data.err.msg !== '') {
        message.error(`${data.err.msg}充值失败`, 10);
      }
    }

    return true;
  } catch (error) {
    return error;
  }
};
// 获取设置信息
const getSystem = async (obj) => {
  try {
    const res = await axios.post('/system/config/getSystem', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 修改设置
const systemEdit = async (obj) => {
  try {
    const res = await axios.post('/system/config/systemEdit', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      message.success(msg);
      return true;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
// 获取意见反馈列表
const getList = async (obj) => {
  try {
    const res = await axios.post('/system/proposal/getList', qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (code === 200) {
      return data;
    } else {
      message.error(msg);
      return false;
    }
  } catch (error) {
    return error;
  }
};
export { getIntegral, integralSet, integralEdit, integralAdd, getSystem, systemEdit, getList };
