import React, { useEffect, useState, useRef } from 'react'
import {
  Table,
  Input,
  Button,
  Row,
  Col,
  Space,
  DatePicker,
  Popover,
  Drawer,
  Form,
  Modal,
  Switch,
  Select,
  Image
} from 'antd'
import { useNavigate } from 'react-router-dom'
import PaginationCom from '@/common/Pagination'
import {
  getTeacherList,
  addTeacher,
  TeacherInfo,
  editTeacher,
  delTeacher,
  changeStatus,
  changePassword,
  getSystem,
  systemEdit
} from './request.js'
import { getAllList } from '../../jurisdiction/role/request.js'
import dayjs from 'dayjs'
import reload from '@/assets/images/icon/reload.png'
import reset from '@/assets/images/icon/reset.png'
import filter from '@/assets/images/icon/filter.png'
import add from '@/assets/images/icon/add.png'
import md5 from 'js-md5'
import TableCom from '@/common/TableCom/index'
import { useSelector } from 'react-redux'
const { RangePicker } = DatePicker
const TeacherModule = () => {
  const [data, setData] = useState([])
  const navigate = useNavigate()
  const [page_size, setpage_size] = useState(10)
  const [page, setPage] = useState(1)
  const [total, setTotal] = useState(0)
  const [loading, setLoading] = useState(true)
  const [showModal, setshowModal] = useState(false)
  const [isAdd, setIsAdd] = useState(false)
  const [delMoadal, setDelModal] = useState(false)
  const [passwordModal, setPasswordModal] = useState(false)
  const [form] = Form.useForm()
  const [form1] = Form.useForm()
  const [form2] = Form.useForm()
  const [isEditValidity, setIsEditValidity] = useState(false)
  // 获取操作权限
  const { operationPermissionsList } = useSelector(state => state.user)

  const [initialValues, setinitialValues] = useState({
    real_name: '',
    tel: '',
    validity: '',
    password: '',
    role_id: null
  })
  const [defaultPassword, setDefalutPassword] = useState({
    password: '',
    re_password: ''
  })
  const flag = useRef(true)
  // 角色列表
  const [roleList, setRoleList] = useState([])
  const [filterObj, setfilterObj] = useState({
    real_name: '',
    tel: '',
    start_time: '',
    end_time: ''
  })
  const [dateVal, setDateVal] = useState('')
  // 过滤
  const handleFilter = (flag, val) => {
    if (flag == 'startandend') {
      let val2 = val || []
      filterObj['start_time'] = parseInt(new Date(dayjs(val2[0]).format('YYYY-MM-DD') + ' 00:00:00').getTime() / 1000)
      const endDate = new Date(dayjs(val2[1])).getDate()
      const endTime = parseInt(new Date(dayjs(val2[1]).format('YYYY-MM-') + endDate + ' 23:59:59').getTime() / 1000)
      filterObj['end_time'] = endTime
      setDateVal(val)
      if (!val2.length) {
        delete filterObj['start_time']
        delete filterObj['end_time']
      }
    } else {
      filterObj[flag] = val
    }
    for (const key in filterObj) {
      if (!filterObj[key]) {
        delete filterObj[key]
      }
    }
    setfilterObj({ ...filterObj })
    if (!val) init(filterObj)
  }
  // 重置
  const handleReset = () => {
    setfilterObj({ real_name: '', tel: '' })
    setDateVal('')
    init()
  }
  const handleStatus = async (val, id) => {
    const bool = await changeStatus({ id, status: val ? '1' : '0' })
    bool && init()
  }
  const init = async (obj = {}) => {
    setLoading(true)
    const { total, list } = await getTeacherList({ page, page_size, ...obj })
    setTotal(total)
    setData(list)
    setLoading(false)
  }
  const [id, setId] = useState(0)
  const handleEdit = async obj => {
    const data = await TeacherInfo({ id: obj.id })
    let { validity, id } = data
    setIsAdd(false)
    setshowModal(true)
    form.setFieldsValue({ ...data, validity: dayjs(validity) })
    setId(id)
  }
  const onClose = () => {
    setshowModal(false)
  }

  const submitForm = async obj => {
    let bool
    let { validity, password } = obj

    console.log(12313)

    if (isAdd) {
      bool = await addTeacher({
        ...obj,
        validity: dayjs(dayjs(validity).format('YYYY-MM-DD') + ' 23:59:59').unix(),
        password: md5(md5(password))
      })
    } else {
      bool = await editTeacher({
        ...obj,
        id,
        validity: dayjs(dayjs(validity).format('YYYY-MM-DD') + ' 23:59:59').unix()
      })
    }
    if (!bool) return
    init()
    setshowModal(false)
  }
  // 修改密码
  const handleChangePassword = async obj => {
    let { password: pas, re_password: repas } = obj
    let password = md5(md5(pas))
    let re_password = md5(md5(repas))
    const bool = await changePassword({ id, password, re_password })
    bool && init()
    setPasswordModal(false)
  }
  const delSuccess = async () => {
    const bool = await delTeacher({ id })
    bool && init()
    setDelModal(false)
  }
  const passwordSuccess = () => {
    setPasswordModal(false)
  }
  // 获取角色
  const getRoleList = async () => {
    const res = await getAllList({ type: 2 })
    setRoleList(res)
  }
  useEffect(() => {
    if (!showModal) {
      form.setFieldsValue(initialValues)
      form.resetFields()
    }
    if (!passwordModal) {
      form2.setFieldsValue(defaultPassword)
      form2.resetFields()
    }
  }, [showModal, passwordModal])
  useEffect(() => {
    getRoleList()
  }, [])

  // 获取设置信息
  const getInfo = async () => {
    const data = await getSystem({ type: 1 })
    form1.setFieldsValue({
      set_value: data.set_value
    })
  }
  // 设置个性化信息
  const handleSystemEdit = async values => {
    const { set_value } = values // 获取输入框的内容
    const data = { type: 1, set_value } // 构造传递给systemEdit的参数对象
    const bool = await systemEdit(data)
    console.log('bool', bool)
    bool && getInfo()
  }
  useEffect(() => {
    if (operationPermissionsList.includes('/teacher/list/getSystem')) {
      getInfo()
    }
  }, [operationPermissionsList])
  const columns = [
    {
      title: 'ID',
      key: 'id',
      dataIndex: 'id'
    },
    {
      title: '老师名称',
      key: 'real_name',
      dataIndex: 'real_name',
      align: 'center',
      width: 200,
      render: text => (
        <Popover content={text} overlayStyle={{ maxWidth: '200px' }}>
          <div
            style={{
              display: '-webkit-box',
              WebkitLineClamp: '2',
              WebkitBoxOrient: 'vertical',
              overflow: 'hidden',
              textOverflow: 'ellipsis'
            }}>
            {text}
          </div>
        </Popover>
      )
    },
    {
      title: '手机号',
      align: 'center',
      key: 'tel',
      dataIndex: 'tel'
    },
    {
      title: '状态',
      key: 'status',
      dataIndex: 'status',
      render(_, { id, status }) {
        return <Switch defaultChecked={status} onChange={ev => handleStatus(ev, id)} />
      }
    },
    {
      title: '有效期',
      align: 'center',
      key: 'validity',
      dataIndex: 'validity'
    },
    {
      title: '创建时间',
      align: 'center',
      key: 'create_time',
      dataIndex: 'create_time'
    },
    {
      title: '操作',
      key: 'handle',
      align: 'center',
      dataIndex: 'handle',
      render: (_, record) => {
        return (
          <Space>
            {operationPermissionsList.includes('/teacher/list/getInfoById') && (
              <Button onClick={() => handleEdit(record)}>编辑</Button>
            )}
            {operationPermissionsList.includes('/teacher/list/del') && (
              <Button
                onClick={() => {
                  setId(record.id)
                  setDelModal(true)
                }}>
                删除
              </Button>
            )}
            {operationPermissionsList.includes('/teacher/list/editPass') && (
              <Button
                onClick={() => {
                  setId(record.id)
                  setPasswordModal(true)
                }}>
                修改密码
              </Button>
            )}
          </Space>
        )
      }
    }
  ]
  return (
    <div>
      {/* <Space style={{ paddingBottom: '40px' }}>
        <label htmlFor='name'>老师分成百分比(%)</label>
        <Input
          autoComplete='off'
          allowClear
          value={filterObj.name}
          onChange={(ev) => handleFilter('name', ev.target.value)}
          placeholder='请输入老师分成百分比'
          id='name'
        ></Input>
        <span style={{ marginLeft: '10px', color: '#999999' }}>
          老师佣金计算(预计总收入),编写书籍售卖总金额+分成比例
        </span>
      </Space> */}
      <Row justify={'space-between'}>
        <Col className="form-devices-inline">
          <Form layout="inline">
            <Form.Item label="老师名称">
              <Input
                autoComplete="off"
                allowClear
                value={filterObj.real_name}
                onChange={ev => handleFilter('real_name', ev.target.value)}
                placeholder="请输入老师名称"
                id="name"></Input>
            </Form.Item>
            <Form.Item label="手机号">
              <Input
                autoComplete="off"
                allowClear
                value={filterObj.tel}
                onChange={ev => handleFilter('tel', ev.target.value)}
                placeholder="请输入手机号"
                id="phone"></Input>
            </Form.Item>
            <Form.Item label="创建时间">
              <RangePicker
                value={dateVal}
                onChange={ev => handleFilter('startandend', ev)}
                id="createTime"></RangePicker>
            </Form.Item>
            <Space>
              <Button
                type="primary"
                ghost
                icon={
                  <span
                    style={{
                      display: 'inline-block',
                      width: '11px',
                      height: '10px',
                      pointerEvents: 'none'
                    }}>
                    <Image src={reset} />
                  </span>
                }
                onClick={handleReset}>
                重置
              </Button>
              <Button
                type="primary"
                icon={
                  <span
                    style={{
                      display: 'inline-block',
                      width: '13px',
                      height: '12px',
                      pointerEvents: 'none'
                    }}>
                    <Image src={filter} />
                  </span>
                }
                ghost
                onClick={() => {
                  setPage(1)
                  console.log(filterObj)
                  Object.values(filterObj).some(item => item) ? init(filterObj) : init()
                }}>
                筛选
              </Button>
              <Button
                type="primary"
                ghost
                icon={
                  <span
                    style={{
                      display: 'inline-block',
                      width: '10px',
                      height: '12px',
                      pointerEvents: 'none'
                    }}>
                    <Image src={reload} />
                  </span>
                }
                onClick={() => {
                  Object.values(filterObj).some(item => item) ? init(filterObj) : init()
                }}>
                刷新
              </Button>
            </Space>
          </Form>
        </Col>
        <Col>
          <Space>
            {operationPermissionsList.includes('/teacher/list/add') && (
              <Button
                type="primary"
                ghost
                icon={
                  <span
                    style={{
                      display: 'inline-block',
                      width: '13px',
                      height: '12px',
                      pointerEvents: 'none'
                    }}>
                    <Image src={add} />
                  </span>
                }
                onClick={() => {
                  setIsAdd(true)
                  setshowModal(true)
                }}>
                添加
              </Button>
            )}
            {operationPermissionsList.includes('/teacher/list/getSystem') && (
              <Button
                type="primary"
                ghost
                onClick={() => {
                  setIsAdd(true)
                  setIsEditValidity(true)
                }}>
                分成设置
              </Button>
            )}
          </Space>
        </Col>
      </Row>
      <br />
      {TableCom({ columns, loading, data })}
      <Modal
        mask={false}
        centered
        open={delMoadal}
        onOk={delSuccess}
        onCancel={() => setDelModal(false)}
        footer={(_, { OkBtn, CancelBtn }) => {
          return (
            <Row justify={'center'} className="delModal" style={{ marginBottom: '30px' }}>
              <Space size={20}>
                <CancelBtn />
                <OkBtn />
              </Space>
            </Row>
          )
        }}
        okText="提交">
        <p style={{ textAlign: 'center', padding: '30px 0 18px', fontSize: 16 }}>老师将永久删除，是否继续?</p>
      </Modal>
      <Drawer
        mask={false}
        centered
        open={passwordModal}
        onOk={passwordSuccess}
        onCancel={() => passwordSuccess(false)}
        onClose={() => passwordSuccess(false)}
        footer={null}
        width={700}
        okText="提交">
        <Form
          initialValues={defaultPassword}
          labelCol={{ span: 6 }}
          form={form2}
          wrapperCol={{ span: 12 }}
          onFinish={handleChangePassword}>
          <Form.Item
            label="新密码"
            name="password"
            wrapperCol={{ span: 16 }}
            rules={[
              { required: true, message: '请输入新密码' },
              {
                pattern:
                  /^((?=.*\d)(?=.*[A-Z])(?=.*[a-z]))|((?=.*\d)(?=.*[A-Z])(?=.*[\W_]))|((?=.*\d)(?=.*[a-z])(?=.*[\W_]))|((?=.*[A-Z])(?=.*[a-z])(?=.*[\W_]))[a-zA-Z\d\W_]{8,12}$/,
                message: '密码至少满足三种格式(大写字母、小写字母、数字、特殊符号), 长度为8~12位字符！',
                trigger: ['change', 'blur']
              },
              {
                validator(_, value) {
                  if (!value || form2.getFieldValue('re_password') === value) {
                    form2.setFields([{ name: 're_password', errors: [''] }])
                    return Promise.resolve()
                  }
                  form2.setFields([{ name: 're_password', errors: ['两次输入的密码不一致'] }])
                  return Promise.reject()
                }
              }
            ]}
            // validateStatus='error' // 设置为 'error' 显示错误样式
          >
            <Input.Password autoComplete="off" placeholder="请输入新密码"></Input.Password>
          </Form.Item>

          <Form.Item
            label="确认新密码"
            name="re_password"
            wrapperCol={{ span: 16 }}
            rules={[
              { required: true, message: '请再次输入新密码' },
              {
                pattern:
                  /^((?=.*\d)(?=.*[A-Z])(?=.*[a-z]))|((?=.*\d)(?=.*[A-Z])(?=.*[\W_]))|((?=.*\d)(?=.*[a-z])(?=.*[\W_]))|((?=.*[A-Z])(?=.*[a-z])(?=.*[\W_]))[a-zA-Z\d\W_]{8,12}$/,
                message: '密码至少满足三种格式(大写字母、小写字母、数字、特殊符号), 长度为8~12位字符！',
                trigger: ['change', 'blur']
              },
              {
                validator(_, value) {
                  if (!value || form2.getFieldValue('password') === value) {
                    return Promise.resolve()
                  }
                  return Promise.reject(new Error('两次输入的密码不一致'))
                }
              }
            ]}>
            <Input.Password autoComplete="off" placeholder="请再次输入新密码"></Input.Password>
          </Form.Item>
          <Form.Item wrapperCol={{ offset: 10, span: 24 }}>
            <Space style={{ justifyContent: 'center' }} size={20}>
              <Button onClick={() => setPasswordModal(false)}>取消</Button>
              <Button type="primary" htmlType="submit">
                提交
              </Button>
            </Space>
          </Form.Item>
        </Form>
      </Drawer>
      <br />
      <PaginationCom
        total={total}
        page_size={page_size}
        setpage_size={setpage_size}
        page={page}
        setPage={setPage}
        init={init}
        filterObj={filterObj}
      />
      <Drawer placement="right" onClose={onClose} open={showModal} mask={false}>
        <Form initialValues={initialValues} form={form} onFinish={submitForm} labelCol={{ span: 6 }}>
          <Form.Item
            name="real_name"
            label="老师姓名"
            rules={[
              { required: true, message: '请输入老师名称' },
              { max: 30, message: '最大30字符' }
            ]}>
            <Input autoComplete="off" placeholder="请输入老师名称"></Input>
          </Form.Item>
          <Form.Item
            name="tel"
            label="手机号"
            rules={[
              { required: true, message: '请输入手机号' },
              {
                pattern: /^(?:(?:\+|00)86)?1[3-9]\d{9}$/,
                message: '请输入正确格式的手机号',
                trigger: 'blur'
              }
            ]}>
            <Input autoComplete="off" placeholder="请输入手机号"></Input>
          </Form.Item>
          <Form.Item name="role_id" label="角色" rules={[{ required: true, message: '请选择角色' }]}>
            <Select placeholder="请选择角色" showSearch optionFilterProp="children">
              {/* <Select placeholder='请选择角色'> */}
              {roleList.length &&
                roleList.map(item => (
                  <Select.Option key={item.id} value={item.id}>
                    {item.name}
                  </Select.Option>
                ))}
            </Select>
          </Form.Item>
          <Form.Item name="validity" label="有效期" rules={[{ required: true, message: '请选择有效期' }]}>
            <DatePicker />
          </Form.Item>
          {isAdd && (
            <Form.Item
              name="password"
              label="初始密码"
              rules={[
                { required: true, message: '请输入密码' },
                {
                  // pattern: /^(?:(?=.*[A-Z])(?=.*[a-z])|(?=.*[A-Z])(?=.*\d)|(?=.*[A-Z])(?=.*[~@#%$*_\-+=;:,.?])|(?=.*[a-z])(?=.*\d)|(?=.*[a-z])(?=.*[~@#%$*_\-+=;:,.?])|(?=.*\d)(?=.*[~@#%$*_\-+=;:,.?])).{8,12}$/,
                  // pattern: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)|(?=.*[a-z])(?=.*\d)(?=.*[~@#%$*_\-+=;:,.?])|(?=.*[A-Z])(?=.*\d)(?=.*[~@#%$*_\-+=;:,.?])|(?=.*[a-z])(?=.*[A-Z])(?=.*[~@#%$*_\-+=;:,.?]).{8,12}$/,
                  pattern:
                    /^((?=.*\d)(?=.*[A-Z])(?=.*[a-z]))|((?=.*\d)(?=.*[A-Z])(?=.*[\W_]))|((?=.*\d)(?=.*[a-z])(?=.*[\W_]))|((?=.*[A-Z])(?=.*[a-z])(?=.*[\W_]))[a-zA-Z\d\W_]{8,12}$/,
                  message: '密码至少满足三种格式(大写字母、小写字母、数字、特殊符号), 长度为8~12位字符！',
                  trigger: ['change', 'blur']
                }
              ]}>
              {/* <Input.Password autoComplete='off' placeholder='请输入密码'/> */}
              <Input.Password autoComplete="off" placeholder="请输入密码" />
            </Form.Item>
          )}
          <Form.Item wrapperCol={{ offset: 5, span: 16 }} style={{ textAlign: 'center' }}>
            <Space size={20}>
              <Button onClick={() => setshowModal(false)}>取消</Button>
              <Button type="primary" htmlType="submit">
                提交
              </Button>
            </Space>
          </Form.Item>
        </Form>
      </Drawer>

      <Drawer
        onClose={() => setIsEditValidity(false)}
        open={isEditValidity}
        footer={null}
        mask={false}
        keyboard={false}
        onCancel={() => setIsEditValidity(false)}>
        <Row align="middle" justify="center">
          <Col span={20}>
            <Form
              form={form1}
              onFinish={handleSystemEdit}
              labelCol={{ span: 9 }}
              wrapperCol={{ span: 26 }} // 调整 wrapperCol，使其与 labelCol 对齐
            >
              <Form.Item label="老师分成百分比(%)" name="set_value" style={{ marginBottom: 10 }}>
                <Input
                  autoComplete="off"
                  style={{ width: '100%' }} // 使用百分比宽度
                  placeholder="请输入老师分成百分比"
                />
              </Form.Item>
              <Form.Item wrapperCol={{ offset: 0, span: 26 }}>
                {/* 调整偏移和跨度，使按钮居中 */}
                <div style={{ color: '#999999', fontSize: 12 }}>
                  老师佣金计算(预计总收入)，编写书籍售卖总金额×分成比例 (范围1-100)
                </div>
              </Form.Item>
              <Form.Item wrapperCol={{ offset: 9, span: 26 }}>
                <Space size={20}>
                  {operationPermissionsList.includes('/teacher/list/systemEdit') && (
                    <Button onClick={() => setIsEditValidity(false)}>取消</Button>
                  )}
                  {operationPermissionsList.includes('/teacher/list/systemEdit') && (
                    <Button type="primary" htmlType="submit" onClick={() => setIsEditValidity(false)}>
                      提交
                    </Button>
                  )}
                </Space>
              </Form.Item>
            </Form>
          </Col>
        </Row>
      </Drawer>
    </div>
  )
}

export default TeacherModule
