import axios from '@/utils/request.js';
import qs from 'qs';
import api from './api.js';
import { get } from 'lodash-es';
import { message } from 'antd';

const login = async (obj) => {
  try {
    const res = await axios.post(api.login, qs.stringify(obj));
    const code = get(res, 'data.code', 0);
    const data = get(res, 'data.data', []);
    const msg = get(res, 'data.message', '数据获取失败！');
    if (msg === 'Undefined index: verify') {
      message.error('请先点击按钮进行验证');
      return false;
    }
    if (code === 200) {
      return {
        code,
        ...data,
      };
    } else {
      message.error(msg);
      return {
        msg,
      };
    }
  } catch (error) {
    console.error(error);
    let msg = get(error.response, 'data.msg', '');
    if (msg) {
      message.error(msg);
    }
    return false;
  }
};

export { login };
