import { create } from 'zustand'

const useUserStore = create((set, get) => ({
  user: {},
  token: '',
  permissions: [],
  updateUser: user => set({ user }),
  updateToken: token => set({ token }),
  updatePermissions: permissions => set({ permissions }),
  checkPermissions: permission => {
    const { permissions } = get()
    return permissions.includes(permission)
  }
}))

export default useUserStore
