export const storageChange = () => {
  let orignalSetItem = localStorage.setItem;
  localStorage.setItem = function (key, newValue) {
    let setItemEvent = new Event('setItemEvent');
    setItemEvent.key = key;
    setItemEvent.newValue = newValue;
    setItemEvent.oldValue = localStorage.getItem(key);
    window.dispatchEvent(setItemEvent);
    orignalSetItem.apply(this, arguments);
  };
};
