import BaseAPI from './base_api'

export default class TestAPI extends BaseAPI {
  /**
   * 获取考试信息
   * @param {[string]} examId resource_id
   */
  getExamInfo = (examId) => this.get(`/xexam/v1/exam/view/${examId}`, {})
  /**
   * 进入考试
   */
  userLogin = (examId, obj = {}) => this.post(`/xexam/v1/user/login/${examId}`, obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  confirmInfo = (examId, obj = {}) => this.post(`/xexam/v1/user/confirm/${examId}`, obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  // /**
  //  * post传输方式
  //  * @param {[object]} obj
  //  */
  // postTest = (obj = {}) => this.post('/passport/rest/login', obj, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
  // /**
  // * 当前登录用户，检测是否该系统有权限
  // */
  // getInfo = () => this.post('/user_center/get_user_info', {}, { headers: { 'Content-Type': 'application/x-www-form-urlencoded' } })
}
