import './index.scss'
import TestModule from './src/TestModule.vue'

const components = [
  TestModule
]

const install = function (Vue, opts = {}) {
  /* 存在国际化 */
  if (opts.i18n) {
    const msgs = opts.i18n.messages
    for (const k in msgs) {
      opts.i18n.setLocaleMessage(k, Object.assign(msgs[k], require('./assets/languages/' + k + '.json')))
    }
  }

  components.forEach(component => {
    Vue.component(component.name, component)
  })
}

/* istanbul ignore if */
if (typeof window !== 'undefined' && window.Vue) {
  install(window.Vue)
}

export default {
  install,
  TestModule
}
