import httpRequest from '@/utils/axios.js'

// 获取考试
export function getExamInfo(examId) {
  return httpRequest.get(`/api/xexam/v1/exam/view/${examId}`)
}

// 登录考试
export function userLogin(examId, data) {
  return httpRequest.post(`/api/xexam/v1/user/login/${examId}`, data)
}

// 确认考试信息
export function confirmInfo(examId, data) {
  return httpRequest.post(`/api/xexam/v1/user/confirm/${examId}`, data)
}

//  发送考试信息
export function sendExamInfo(data) {
  return httpRequest.post('/api/call/v1/exam/student-status/commit', data)
}

// 获取试卷
export function getTopic(examId, params) {
  return httpRequest.get(`/api/xexam/v1/exam/sheet/${examId}`, { params })
}

// 获取试卷缓存
export function getCache(examId) {
  return httpRequest.get(`/api/xexam/v1/exam/cache/${examId}`)
}

// 缓存试卷
export function setCache(examId, data) {
  return httpRequest.post(`/api/xexam/v1/exam/cache/${examId}`, data)
}

// 提交考试
export function endExam(examId, data) {
  return httpRequest.post(`/api/xexam/v1/exam/sheet/${examId}`, data)
}
